/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import javax.portlet.PortletRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeCredentialsService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.portlet.context.PortletRequestAttributes;

@Component
public class ExchangeWsCredentialsProvider
implements CredentialsProvider,
IExchangeCredentialsService {
    protected static final String EXCHANGE_CREDENTIALS_ATTRIBUTE = "exchangeCredentials";

    public void clear() {
    }

    public Credentials getCredentials(AuthScope authscope) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Credentials credentials = (Credentials)requestAttributes.getAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, 1);
        return credentials;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        throw new UnsupportedOperationException("Exchange does not support this method - use initialize");
    }

    @Override
    public void initialize(PortletRequest request, MailStoreConfiguration config, IAuthenticationService authService) {
        Credentials credentials = authService.getCredentials(request, config);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            requestAttributes = new PortletRequestAttributes(request);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
        }
        requestAttributes.setAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, (Object)credentials, 1);
    }

    @Override
    public String getUsername() {
        return this.getCredentials(null).getUserPrincipal().getName();
    }
}

