/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.util;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public final class MessageUtils
implements InitializingBean,
ApplicationContextAware {
    private static final String CLICKABLE_URLS_REGEX = "\\b((?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$]))";
    private static final Pattern CLICKABLE_URLS_PATTERN = Pattern.compile("\\b((?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$]))", 2);
    private static final String CLICKABLE_URLS_PART1 = "<a href=\"";
    private static final String CLICKABLE_URLS_PART2 = "\" target=\"_new\">";
    private static final String CLICKABLE_URLS_PART3 = "</a>";
    private static final Log LOG = LogFactory.getLog(MessageUtils.class);
    private String filePath = "classpath:antisamy.xml";
    private ApplicationContext ctx;
    private Policy policy;

    public void setSecurityFile(String path) {
        this.filePath = path;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public void afterPropertiesSet() throws Exception {
        InputStream stream = this.ctx.getResource(this.filePath).getInputStream();
        this.policy = Policy.getInstance((InputStream)stream);
    }

    public String cleanHTML(String message) {
        try {
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(message, this.policy);
            return cr.getCleanHTML();
        }
        catch (ScanException e) {
            throw new EmailPreviewException("Error cleansing email message", e);
        }
        catch (PolicyException e) {
            throw new EmailPreviewException("Error with AntiSamy policy exception", e);
        }
    }

    public static String addClickableUrlsToMessageBody(String msgBody) {
        if (msgBody == null) {
            String msg = "Argument 'msgBody' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        StringBuffer rslt = new StringBuffer();
        Matcher m = CLICKABLE_URLS_PATTERN.matcher(msgBody);
        while (m.find()) {
            String url;
            StringBuilder bldr = new StringBuilder();
            String text = m.group(1);
            String string = url = text.startsWith("www.") ? "http://" + text : text;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Making embedded URL '" + text + "' clickable at the following href:  " + url));
            }
            bldr.append(CLICKABLE_URLS_PART1).append(url).append(CLICKABLE_URLS_PART2).append(text).append(CLICKABLE_URLS_PART3);
            m.appendReplacement(rslt, bldr.toString());
        }
        m.appendTail(rslt);
        return rslt.toString();
    }
}

