/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portlet.emailpreview.security;

/**
 * IStringEncryptionService is a small interface for string encryption/decryption.
 * It is expected that this service will generally consist of a small wrapper
 * for some other encryption API.
 * 
 * @author bourey
 */
public interface IStringEncryptionService {
    
    /**
     * Encrypt a string
     * 
     * @param plaintext
     * @return encrypted version of the plaintext
     * @throws StringEncryptionException
     */
    public String encrypt(String plaintext);
    
    /**
     * Decrypt a string
     * 
     * @param cryptotext
     * @return decrypted version of the cryptotext
     * @throws StringEncryptionException
     */
    public String decrypt(String cryptotext);

    /**
     * Returns true if the encryptor is configured to use the default encryption key.
     * @return true if encryption key is default value
     */
    public boolean usingDefaultEncryptionKey();

}
