/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao;

import java.io.Serializable;
import java.util.List;
import javax.mail.Folder;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.caching.AccountSummaryCacheKeyGeneratorImpl;
import org.jasig.portlet.emailpreview.caching.IAccountSummaryCacheKeyGenerator;
import org.jasig.portlet.emailpreview.caching.IMailAccountCacheKeyGenerator;
import org.jasig.portlet.emailpreview.caching.MailAccountCacheKeyGeneratorImpl;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.dao.IMailAccountDao;
import org.jasig.portlet.emailpreview.service.ICredentialsProvider;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

public class EmailAccountService
implements IEmailAccountService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    @Qualifier(value="simpleServiceBroker")
    private IServiceBroker serviceBroker;
    private IMailAccountDao dao;
    @Autowired
    private ICredentialsProvider credentialsService;
    @Autowired
    @Qualifier(value="inboxCache")
    private Cache inboxCache;
    private IAccountSummaryCacheKeyGenerator accountSummaryCacheKeyGenerator = new AccountSummaryCacheKeyGeneratorImpl();
    @Autowired
    @Qualifier(value="exchangeFolderCache")
    private Cache folderCache;
    private IMailAccountCacheKeyGenerator folderCacheKeyGenerator = new MailAccountCacheKeyGeneratorImpl();
    private String folderCacheKeyPrefix = "MailFolders";

    public void setInboxCache(Cache inboxCache) {
        this.inboxCache = inboxCache;
    }

    public void setAccountSummaryCacheKeyGenerator(IAccountSummaryCacheKeyGenerator accountSummaryCacheKeyGenerator) {
        this.accountSummaryCacheKeyGenerator = accountSummaryCacheKeyGenerator;
    }

    public void setFolderCache(Cache folderCache) {
        this.folderCache = folderCache;
    }

    public void setFolderCacheKeyGenerator(IMailAccountCacheKeyGenerator folderCacheKeyGenerator) {
        this.folderCacheKeyGenerator = folderCacheKeyGenerator;
    }

    public void setFolderCacheKeyPrefix(String folderCacheKeyPrefix) {
        this.folderCacheKeyPrefix = folderCacheKeyPrefix;
    }

    @Required
    public void setDao(IMailAccountDao dao) {
        this.dao = dao;
    }

    public void setCredentialsService(ICredentialsProvider credentialsService) {
        this.credentialsService = credentialsService;
    }

    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh, String folder) {
        Element element;
        String username = req.getRemoteUser();
        if (username == null) {
            throw new EmailPreviewException("Anonymous access is not supported");
        }
        MailStoreConfiguration config = this.initializeEnvironment(req);
        config.setInboxFolderName(folder);
        String mailAccount = config.getMailAccount();
        String key = this.accountSummaryCacheKeyGenerator.getKey(this.credentialsService.getUsername(), mailAccount, folder, config.getProtocol());
        if (!refresh && (element = this.inboxCache.get((Serializable)((Object)key))) != null) {
            AccountSummary summary = (AccountSummary)element.getObjectValue();
            if (summary.getMessagesStart() == start && summary.getMessagesMax() == max) {
                this.log.debug("Returning cached AccountSummary for [username={}, mailAccount={}, folder={}, start={}, max={}]", new Object[]{username, mailAccount, folder, start, max});
                return summary;
            }
            this.log.debug("Different min or max than cached data so fetching data for username={}, mailAccount={}", (Object)username, (Object)mailAccount);
        }
        this.log.debug("Creating new AccountSummary for [username={}, mailAccount={}, folder={}, start={}, max={}]", new Object[]{username, mailAccount, folder, start, max});
        AccountSummary summary = this.dao.fetchAccountSummaryFromStore(config, username, mailAccount, folder, start, max);
        Element element2 = new Element((Object)key, (Object)summary);
        this.inboxCache.put(element2);
        return summary;
    }

    private void populateCredentials(PortletRequest req, MailStoreConfiguration config) {
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        this.credentialsService.initialize(req, config, authService);
    }

    private MailStoreConfiguration setupMailStoreConfig(PortletRequest req) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (authService == null) {
            String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
            this.log.error(msg);
            throw new EmailPreviewException(msg);
        }
        String mailAccount = authService.getMailAccountName(req, config);
        config.setMailAccount(mailAccount);
        return config;
    }

    private MailStoreConfiguration initializeEnvironment(PortletRequest req) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        this.populateCredentials(req, config);
        return config;
    }

    private void clearInboxCache(MailStoreConfiguration config) {
        String key = this.accountSummaryCacheKeyGenerator.getKey(this.credentialsService.getUsername(), config.getMailAccount(), config.getInboxFolderName(), config.getProtocol());
        this.inboxCache.remove((Serializable)((Object)key));
    }

    public EmailMessage getMessage(PortletRequest req, String messageId) {
        MailStoreConfiguration config = this.initializeEnvironment(req);
        if (config.getMarkMessagesAsRead()) {
            this.log.debug("Getting message - marking message as read (may already be marked as read");
            this.setSeenFlag(req, new String[]{messageId}, true);
            this.clearInboxCache(config);
        }
        this.log.debug("Getting message id={}", (Object)messageId);
        return this.dao.getMessage(config, messageId);
    }

    public boolean deleteMessages(PortletRequest req, String[] messageIds) {
        MailStoreConfiguration config = this.initializeEnvironment(req);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting messages {}", (Object)this.convertIdsToString(messageIds));
        }
        boolean wasDeleted = this.dao.deleteMessages(config, messageIds);
        this.clearInboxCache(config);
        return wasDeleted;
    }

    private String convertIdsToString(String[] messageIds) {
        StringBuffer ids = new StringBuffer();
        for (String id : messageIds) {
            ids.append(id).append(",");
        }
        ids.deleteCharAt(ids.length() - 1);
        return ids.toString();
    }

    public boolean setSeenFlag(PortletRequest req, String[] messageIds, boolean read) {
        MailStoreConfiguration config = this.initializeEnvironment(req);
        boolean result = this.dao.setMessageReadStatus(config, messageIds, read);
        this.clearInboxCache(config);
        return result;
    }

    public List<Folder> getAllUserInboxFolders(PortletRequest req) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        this.populateCredentials(req, config);
        String key = this.folderCacheKeyGenerator.getKey(this.credentialsService.getUsername(), config.getMailAccount(), this.folderCacheKeyPrefix);
        Element element = this.folderCache.get((Serializable)((Object)key));
        if (element != null) {
            this.log.debug("Returning folder list from cache for user {} mail account {}", (Object)this.credentialsService.getUsername(), (Object)config.getMailAccount());
            return (List)element.getObjectValue();
        }
        this.log.debug("Fetching all folders");
        List folders = this.dao.getAllUserInboxFolders(config);
        this.folderCache.put(new Element((Object)key, (Object)folders));
        return folders;
    }
}

