/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutodiscoverRedirectStrategy
extends LaxRedirectStrategy {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<String> unsafeUriExclusionPatterns;
    private List<Pattern> unsafeUriPatterns = new ArrayList<Pattern>();
    private List<String> requiredUriPatterns;
    private List<Pattern> uriRequirementPatterns = new ArrayList<Pattern>();

    public AutodiscoverRedirectStrategy() {
        this.setRequiredUriPatterns(Arrays.asList("^https:.*"));
    }

    public void setUnsafeUriExclusionPatterns(List<String> unsafeUriExclusionPatterns) {
        this.unsafeUriExclusionPatterns = unsafeUriExclusionPatterns;
        this.unsafeUriPatterns = new ArrayList<Pattern>();
        for (String pattern : unsafeUriExclusionPatterns) {
            this.unsafeUriPatterns.add(Pattern.compile(pattern));
        }
    }

    public void setRequiredUriPatterns(List<String> requiredUriPatterns) {
        this.requiredUriPatterns = requiredUriPatterns;
        this.uriRequirementPatterns = new ArrayList<Pattern>();
        for (String pattern : requiredUriPatterns) {
            this.uriRequirementPatterns.add(Pattern.compile(pattern));
        }
    }

    private boolean matchesPatternSet(URI uri, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(uri.toString());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        this.log.info("Following redirect to {}", (Object)uri.toString());
        String method = request.getRequestLine().getMethod();
        int status = response.getStatusLine().getStatusCode();
        if (this.matchesPatternSet(uri, this.unsafeUriPatterns)) {
            this.log.warn("Not following to URI {} - matches a configured unsafe URI pattern", (Object)uri.toString());
            throw new EmailPreviewException("Autodiscover redirected to unsafe URI " + uri.toString());
        }
        if (!this.matchesPatternSet(uri, this.uriRequirementPatterns) && this.uriRequirementPatterns.size() > 0) {
            this.log.warn("Not following to URI {} - URI does not match a required URI pattern", (Object)uri.toString());
            throw new EmailPreviewException("Autodiscover redirected to URI not matching required pattern. URI=" + uri.toString());
        }
        if ((status == 307 || status == 301 || status == 302) && method.equalsIgnoreCase("POST")) {
            return this.copyEntity((HttpEntityEnclosingRequestBase)new HttpPost(uri), request);
        }
        return new HttpGet(uri);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

