/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.security;

import javax.annotation.PostConstruct;
import org.jasig.portlet.emailpreview.security.IStringEncryptionService;
import org.jasig.portlet.emailpreview.security.StringEncryptionException;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class JasyptPBEStringEncryptionServiceImpl
implements IStringEncryptionService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PBEStringEncryptor encryptor = null;

    @Required
    public void setStringEncryptor(PBEStringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public String encrypt(String plaintext) {
        try {
            return this.encryptor.encrypt(plaintext);
        }
        catch (EncryptionInitializationException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            throw new StringEncryptionException("Encryption error. Verify an encryption password is configured in configuration.properties", e);
        }
    }

    private String decrypt(String cryptotext, boolean logError) {
        try {
            return this.encryptor.decrypt(cryptotext);
        }
        catch (EncryptionInitializationException e) {
            if (logError) {
                this.logger.warn("Decryption failed.  Error message: {}", (Object)e.getMessage());
            }
            throw new StringEncryptionException("Decryption error. Was encryption password changed in the configuration.properties?", e);
        }
        catch (EncryptionOperationNotPossibleException e) {
            if (logError) {
                this.logger.warn("Decryption failed.  This suggests the salt key in configuration.properties has been changed.");
            }
            throw new StringEncryptionException("Decryption error. Was encryption password changed in the configuration.properties?", e);
        }
    }

    @Override
    public String decrypt(String cryptotext) {
        return this.decrypt(cryptotext, true);
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        String enc = this.encrypt(this.getClass().getName());
        Assert.notNull((Object)enc, (String)"String encryption service is not properly configured.");
        String dec = this.decrypt(enc);
        Assert.notNull((Object)dec, (String)"String decryption service is not properly configured.");
        Assert.isTrue((boolean)dec.equals(this.getClass().getName()), (String)("String decryption failed to decode the encrypted text " + enc));
        if (this.usingDefaultEncryptionKey()) {
            this.logger.error("Encryption key at default value.  Change it in configuration.properties for improved security!");
        }
    }

    @Override
    public boolean usingDefaultEncryptionKey() {
        try {
            String result = this.decrypt("pD2vrJ0CiAbnW4k4lF84S8yXN6gSl6VUjISd8NN6AFnDGuei5rGyuw==", false);
            return "EncryptionKeyStillchangeMe".equals(result);
        }
        catch (StringEncryptionException e) {
            return false;
        }
    }
}

