/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.link;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

@Component
public class LinkServiceRegistryImpl
implements ILinkServiceRegistry {
    private Map<String, IEmailLinkService> serviceMap = new HashMap<String, IEmailLinkService>();

    @Resource(name="linkServices")
    @Required
    public void setServices(Collection<IEmailLinkService> services) {
        this.serviceMap.clear();
        for (IEmailLinkService service : services) {
            this.registerService(service);
        }
    }

    @Override
    public IEmailLinkService getEmailLinkService(String key) {
        return this.serviceMap.get(key);
    }

    @Override
    public Collection<IEmailLinkService> getServices() {
        return this.serviceMap.values();
    }

    @Override
    public void registerService(IEmailLinkService linkService) {
        this.serviceMap.put(linkService.getKey(), linkService);
    }
}

