/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jasig.portlet.emailpreview.EmailMessageContent;

public class EmailMessage {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"h:mm a MMM d, yyyy");
    private final int messageNumber;
    private final String uid;
    private final String sender;
    private final String subject;
    private final Date sentDate;
    private boolean unread;
    private final boolean answered;
    private final boolean deleted;
    private boolean multipart;
    private String contentType;
    private final EmailMessageContent content;
    private final String toRecipients;
    private final String ccRecipients;
    private final String bccRecipients;

    public EmailMessage(int messageNumber, String uid, String sender, String subject, Date sentDate, boolean unread, boolean answered, boolean deleted, boolean multipart, String contentType, EmailMessageContent content, String toRecipients, String ccRecipients, String bccRecipients) {
        this.messageNumber = messageNumber;
        this.uid = uid;
        this.sender = sender;
        this.subject = subject;
        this.sentDate = sentDate;
        this.unread = unread;
        this.answered = answered;
        this.deleted = deleted;
        this.multipart = multipart;
        this.contentType = contentType;
        this.content = content;
        this.toRecipients = toRecipients;
        this.ccRecipients = ccRecipients;
        this.bccRecipients = bccRecipients;
    }

    public EmailMessage(int messageNumber, String uid, String sender, String subject, Date sentDate, boolean unread, boolean answered, boolean deleted, boolean multipart, String contentType, EmailMessageContent content) {
        this(messageNumber, uid, sender, subject, sentDate, unread, answered, deleted, multipart, contentType, content, null, null, null);
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public String getUid() {
        return this.uid;
    }

    public String getMessageId() {
        return StringUtils.isNotBlank((String)this.uid) ? this.uid : new Integer(this.messageNumber).toString();
    }

    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }

    public String getSentDateString() {
        return this.sentDate != null ? DATE_FORMAT.format(this.sentDate) : "";
    }

    public String getSender() {
        return this.sender != null ? this.sender : "(No Sender)";
    }

    public String getSenderName() {
        String senderName = this.getSender();
        if (this.getSender().contains("&lt;")) {
            senderName = this.getSender().split("\\s*&lt;")[0];
        } else if (this.getSender().contains("<")) {
            senderName = this.getSender().split("\\s*<")[0];
        }
        return senderName;
    }

    public String getSubject() {
        if (this.subject == null) {
            return "(No Subject)";
        }
        return this.subject.replace("<", "&lt;").replace(">", "&gt;");
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getContentType() {
        return this.contentType;
    }

    public EmailMessageContent getContent() {
        return this.content;
    }

    public String getToRecipients() {
        return this.toRecipients;
    }

    public String getCcRecipients() {
        return this.ccRecipients;
    }

    public String getBccRecipients() {
        return this.bccRecipients;
    }
}

