/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.Hashtable;
import java.util.Map;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.jasig.portlet.emailpreview.controller.BaseEmailController;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxUpdateInboxFolderController
extends BaseEmailController {
    public static final String SELECTED_OPTION = "selected";
    public static final String INBOX_DEFAULT_VALUE_PREF = "INBOX";
    public static final String AUTH_SERVICE_PREFERENCE = "authenticationServiceKey";
    public static final String AUTH_SERVICE_DEFAULT_VALUE_PREFERENCE = "dummy";
    public static final String AUTH_SERVICE_TEST_PREFERENCE = "demoAuthService";
    public static final String UNREAD_MSG_FLAG = ":unread";

    @ResourceMapping(value="inboxFolder")
    public ModelAndView inboxFolder(ResourceRequest req, ResourceResponse res) throws MessagingException {
        IEmailAccountService accountDao = this.serviceBroker.getEmailAccountService((PortletRequest)req);
        PortletPreferences prefs = req.getPreferences();
        String selectedFolder = prefs.getValue("inboxName", INBOX_DEFAULT_VALUE_PREF);
        String authenticationServiceKey = prefs.getValue(AUTH_SERVICE_PREFERENCE, AUTH_SERVICE_DEFAULT_VALUE_PREFERENCE);
        Hashtable<String, String> jsonData = new Hashtable<String, String>();
        if (AUTH_SERVICE_TEST_PREFERENCE.equals(authenticationServiceKey)) {
            jsonData.put(INBOX_DEFAULT_VALUE_PREF, INBOX_DEFAULT_VALUE_PREF);
            jsonData.put("demoTest", "demoTest");
            jsonData.put("Important", "Important");
            for (Map.Entry entry : jsonData.entrySet()) {
                if (!((String)entry.getValue()).equals(selectedFolder)) continue;
                jsonData.put(SELECTED_OPTION, (String)entry.getValue());
                break;
            }
        } else {
            for (Folder folderName : accountDao.getAllUserInboxFolders((PortletRequest)req)) {
                if ((folderName.getType() & 1) == 0) continue;
                String unreadMsgCount = "";
                if (folderName.getUnreadMessageCount() != 0 && !selectedFolder.equals(folderName.toString())) {
                    unreadMsgCount = " (".concat(String.valueOf(folderName.getUnreadMessageCount())).concat(")").concat(UNREAD_MSG_FLAG);
                }
                jsonData.put(folderName.toString().concat(unreadMsgCount), folderName.toString());
                if (!selectedFolder.equals(folderName.toString())) continue;
                jsonData.put(SELECTED_OPTION, folderName.toString());
            }
        }
        return new ModelAndView("json", jsonData);
    }
}

