/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth.cas;

import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.auth.BaseCredentialsAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;
import org.jasig.portlet.emailpreview.service.auth.cas.ICASProxyTicketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationService
extends BaseCredentialsAuthenticationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String key = "cas";
    protected ICASProxyTicketService casTicketService;
    protected String serviceUrl;
    protected String CAS_ASSERTION_KEY = "CAS_ASSERTION_KEY";

    public void setCasTicketService(ICASProxyTicketService casTicketService) {
        this.casTicketService = casTicketService;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    protected String getProxyPrincipalname(PortletRequest request) {
        Assertion casAssertion = this.getCasAssertion(request);
        String proxyPrincipalname = casAssertion.getPrincipal().getName();
        return proxyPrincipalname;
    }

    protected Assertion getCasAssertion(PortletRequest request) {
        PortletSession session = request.getPortletSession(true);
        Assertion casAssertion = (Assertion)session.getAttribute(this.CAS_ASSERTION_KEY);
        if (casAssertion == null) {
            casAssertion = this.casTicketService.getProxyTicket(request);
            if (casAssertion == null) {
                throw new RuntimeException("CasAssertion is null : Auth ProxyCAS failed. Please check your CAS configuration.");
            }
            session.setAttribute(this.CAS_ASSERTION_KEY, (Object)casAssertion);
        }
        return casAssertion;
    }

    public boolean isConfigured(PortletRequest request, MailStoreConfiguration config) {
        return true;
    }

    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        Assertion casAssertion = this.getCasAssertion(request);
        String proxyPrincipalname = this.getProxyPrincipalname(request);
        String proxyTicket = this.casTicketService.getCasServiceToken(casAssertion, this.serviceUrl);
        return new SimplePasswordAuthenticator(proxyPrincipalname, proxyTicket);
    }

    public Credentials getCredentials(PortletRequest request, MailStoreConfiguration config) {
        String proxyPrincipalname = this.getProxyPrincipalname(request);
        this.log.debug("CAS ticket doesn't make sense with Exchange integration, creating null password credential for " + proxyPrincipalname);
        return new UsernamePasswordCredentials(proxyPrincipalname, null);
    }

    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        String proxyPrincipalname = this.getProxyPrincipalname(request);
        return proxyPrincipalname;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

