/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.controller.BaseEmailController;
import org.jasig.portlet.emailpreview.controller.EmailSummaryController;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.mvc.Attribute;
import org.jasig.portlet.emailpreview.mvc.MailStoreConfigurationForm;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"EDIT"})
public final class EditPreferencesController
extends BaseEmailController {
    private static final String UNCHANGED_PASSWORD = "uNch@ng3d.pswd!";
    private static final String CONFIG_FORM_KEY = "org.jasig.portlet.emailpreview.controller.CONFIG_FORM_KEY";
    private static final String FOCUS_ON_PREVIEW_PREFERENCE = "focusOnPreview";
    private static final String DEFAULT_FOCUS_ON_PREVIEW = "true";
    private IAuthenticationServiceRegistry authServiceRegistry;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="nonUserProtocols")
    private Set<String> nonUserProtocols;

    @RequestMapping
    public ModelAndView getAccountFormView(RenderRequest req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        MailStoreConfiguration config = this.serviceBroker.getConfiguration((PortletRequest)req);
        PortletSession session = req.getPortletSession(false);
        MailStoreConfigurationForm form = (MailStoreConfigurationForm)session.getAttribute(CONFIG_FORM_KEY);
        if (form == null) {
            form = MailStoreConfigurationForm.create(config, (PortletRequest)req);
        } else {
            session.removeAttribute(CONFIG_FORM_KEY);
        }
        model.put("form", form);
        model.put("disableProtocol", config.isReadOnly((PortletRequest)req, MailPreferences.PROTOCOL));
        model.put("disableHost", config.isReadOnly((PortletRequest)req, MailPreferences.HOST));
        model.put("disablePort", config.isReadOnly((PortletRequest)req, MailPreferences.PORT));
        model.put("disableAuthService", config.isReadOnly((PortletRequest)req, MailPreferences.AUTHENTICATION_SERVICE_KEY));
        model.put("disableMarkMessagesAsRead", config.isReadOnly((PortletRequest)req, MailPreferences.MARK_MESSAGES_AS_READ));
        model.put("disableInboxName", config.isReadOnly((PortletRequest)req, MailPreferences.INBOX_NAME));
        model.put("protocols", this.filterNonUserProtocols(this.serviceBroker.getSupportedProtocols()));
        model.put("adminOnlyProtocol", this.protocolSetToNonUserProtocol(config.getProtocol()));
        HashMap<String, IAuthenticationService> authServices = new HashMap<String, IAuthenticationService>();
        for (String key : config.getAllowableAuthenticationServiceKeys()) {
            IAuthenticationService auth = this.authServiceRegistry.getAuthenticationService(key);
            if (auth != null) {
                authServices.put(key, auth);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("Portlet specified an allowable Authentication Service that is unknown to the registry:  '" + key + "'");
        }
        model.put("authenticationServices", authServices);
        if (form.getAdditionalProperties().containsKey(MailPreferences.PASSWORD.getKey())) {
            model.put("unchangedPassword", UNCHANGED_PASSWORD);
        }
        model.put("userInfo", req.getAttribute("javax.portlet.userinfo"));
        if (req.getParameter("errorMessage") != null) {
            model.put("errorMessage", req.getParameter("errorMessage"));
        }
        return new ModelAndView("editPreferences", model);
    }

    private Set<String> filterNonUserProtocols(Set<String> protocols) {
        HashSet<String> filteredSet = new HashSet<String>(protocols);
        filteredSet.removeAll(this.nonUserProtocols);
        return filteredSet;
    }

    private boolean protocolSetToNonUserProtocol(String protocol) {
        return this.nonUserProtocols.contains(protocol);
    }

    @RequestMapping(params={"action=updatePreferences"})
    public void updatePreferences(ActionRequest req, ActionResponse res) throws PortletModeException {
        PortletPreferences prefs = req.getPreferences();
        if (!prefs.isReadOnly("defaultView")) {
            String defaultViewParam = req.getParameter("defaultView");
            String currentDefaultView = prefs.getValue("defaultView", EmailSummaryController.View.ROLLUP.getKey());
            if (defaultViewParam != null && !currentDefaultView.equals(defaultViewParam)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Changing users default view for user '" + req.getRemoteUser() + "' to:  '" + defaultViewParam + "'");
                }
                try {
                    prefs.setValue("defaultView", defaultViewParam);
                    prefs.store();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to set defalutView preference", t);
                }
            }
        }
        if (!prefs.isReadOnly(FOCUS_ON_PREVIEW_PREFERENCE)) {
            String focusOnPreviewParam = req.getParameter(FOCUS_ON_PREVIEW_PREFERENCE);
            String focusOnPreviewSelection = focusOnPreviewParam != null ? focusOnPreviewParam : "false";
            String currentFocusOnPreview = prefs.getValue(FOCUS_ON_PREVIEW_PREFERENCE, DEFAULT_FOCUS_ON_PREVIEW);
            if (!currentFocusOnPreview.equals(focusOnPreviewSelection)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Changing focusOnPreview setting for user '" + req.getRemoteUser() + "' to:  '" + focusOnPreviewSelection + "'");
                }
                try {
                    prefs.setValue(FOCUS_ON_PREVIEW_PREFERENCE, focusOnPreviewSelection);
                    prefs.store();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to set focusOnPreview preference", t);
                }
            }
        }
        MailStoreConfiguration config = this.serviceBroker.getConfiguration((PortletRequest)req);
        MailStoreConfigurationForm form = MailStoreConfigurationForm.create(config, (PortletRequest)req);
        String err = null;
        String protocol = req.getParameter(MailPreferences.PROTOCOL.getKey());
        protocol = protocol != null ? protocol.trim() : "";
        boolean hostConfigRequired = this.hostConfigRequired(protocol);
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.PROTOCOL)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Receieved the following user input for Protocol:  '" + protocol + "'");
            }
            if (!this.serviceBroker.getSupportedProtocols().contains(protocol)) {
                throw new RuntimeException("Unsupported protocol:  " + protocol);
            }
            form.setProtocol(protocol);
            if (protocol.length() == 0 && err == null) {
                err = "Server Protocol is required";
            }
        }
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.HOST)) {
            String host = req.getParameter(MailPreferences.HOST.getKey());
            String string = host = host != null ? host.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug("Receieved the following user input for Host:  '" + host + "'");
            }
            form.setHost(host);
            if (hostConfigRequired && host.length() == 0 && err == null) {
                err = "Server Name is required";
            }
        }
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.PORT)) {
            String port = req.getParameter(MailPreferences.PORT.getKey());
            String string = port = port != null ? port.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug("Receieved the following user input for Port:  '" + port + "'");
            }
            try {
                form.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException nfe) {
                this.log.debug("The specified value is not a number:  " + port, (Throwable)nfe);
            }
            if (hostConfigRequired && port.length() == 0 && err == null) {
                err = "Server Port is required";
            }
        }
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.MARK_MESSAGES_AS_READ)) {
            String markMessagesAsRead = req.getParameter(MailPreferences.MARK_MESSAGES_AS_READ.getKey());
            this.log.debug("Received the following user input for markMessagesAsRead: {}", (Object)markMessagesAsRead);
            form.setMarkMessagesAsRead("on".equalsIgnoreCase(markMessagesAsRead));
        }
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.INBOX_NAME)) {
            String inboxName = req.getParameter(MailPreferences.INBOX_NAME.getKey());
            if (StringUtils.isBlank((CharSequence)inboxName) && StringUtils.isBlank((CharSequence)err)) {
                err = "Inbox folder name is required";
            } else {
                form.setInboxFolderName(inboxName);
            }
        }
        if (!config.isReadOnly((PortletRequest)req, MailPreferences.AUTHENTICATION_SERVICE_KEY)) {
            String authKey = req.getParameter(MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey());
            String string = authKey = authKey != null ? authKey.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug("Receieved the following user input for AuthN Service Key:  '" + authKey + "'");
            }
            if (authKey.length() != 0 && config.getAllowableAuthenticationServiceKeys().contains(authKey)) {
                form.setAuthenticationServiceKey(authKey);
            }
        }
        String ppPassword = null;
        if ("portletPreferences".equals(form.getAuthenticationServiceKey())) {
            if (!config.isReadOnly((PortletRequest)req, MailPreferences.MAIL_ACCOUNT)) {
                String mailAccount = req.getParameter(MailPreferences.MAIL_ACCOUNT.getKey());
                String string = mailAccount = mailAccount != null ? mailAccount.trim() : "";
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Receieved the following user input for mailAccount:  '" + mailAccount + "'");
                }
                if (mailAccount.length() != 0) {
                    form.getAdditionalProperties().put(MailPreferences.MAIL_ACCOUNT.getKey(), new Attribute(mailAccount));
                } else {
                    form.getAdditionalProperties().remove(MailPreferences.MAIL_ACCOUNT.getKey());
                }
            }
            if (!config.isReadOnly((PortletRequest)req, MailPreferences.PASSWORD)) {
                String password = req.getParameter("ppauth_password");
                String string = password = password != null ? password.trim() : "";
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Receieved user input of the following length for Password:  " + password.length());
                }
                if (!UNCHANGED_PASSWORD.equals(password)) {
                    if (password.length() != 0) {
                        ppPassword = password;
                    } else {
                        err = "Password is required for this form of authentication";
                        form.getAdditionalProperties().remove(MailPreferences.PASSWORD.getKey());
                    }
                }
            }
        }
        if (err == null) {
            config.setProtocol(form.getProtocol());
            config.setHost(form.getHost());
            config.setPort(form.getPort());
            config.setMarkMessagesAsRead(form.getMarkMessagesAsRead());
            config.setAuthenticationServiceKey(form.getAuthenticationServiceKey());
            config.setInboxFolderName(form.getInboxFolderName());
            if ("portletPreferences".equals(form.getAuthenticationServiceKey())) {
                Attribute username = form.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
                config.getAdditionalProperties().put(MailPreferences.MAIL_ACCOUNT.getKey(), username.getValue());
                if (ppPassword != null) {
                    config.getAdditionalProperties().put(MailPreferences.PASSWORD.getKey(), ppPassword);
                }
            } else {
                config.getAdditionalProperties().remove(MailPreferences.MAIL_ACCOUNT.getKey());
                config.getAdditionalProperties().remove(MailPreferences.PASSWORD.getKey());
            }
            this.serviceBroker.saveConfiguration(req, config);
            req.getPortletSession().setAttribute("forceRefresh", (Object)Boolean.TRUE);
            res.setPortletMode(PortletMode.VIEW);
        } else {
            res.setRenderParameter("errorMessage", err);
            req.getPortletSession().setAttribute(CONFIG_FORM_KEY, (Object)form);
        }
    }

    private boolean hostConfigRequired(String protocol) {
        return !"ExchangeWebServices".equals(protocol);
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }
}

