/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCredentialsAuthenticationService
implements IAuthenticationService {
    private static final String MAIL_ATTRIBUTE = "mail";
    protected List<ConfigurationParameter> userParameters = Collections.emptyList();
    protected List<ConfigurationParameter> adminParameters = Collections.emptyList();
    protected Map<String, ConfigurationParameter> configParams = Collections.emptyMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return this.adminParameters;
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return this.userParameters;
    }

    protected void setUserParameters(List<ConfigurationParameter> params) {
        this.userParameters = params;
    }

    protected void setAdminParameters(List<ConfigurationParameter> params) {
        this.adminParameters = params;
    }

    protected void setConfigParams(Map<String, ConfigurationParameter> params) {
        this.configParams = params;
    }

    protected String createMailAccountName(String accountName, PortletRequest req, MailStoreConfiguration config) {
        if ("ExchangeWebServices".equals(config.getProtocol()) && config.isEwsUseMailAttribute()) {
            Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
            String emailAddress = (String)userInfo.get(MAIL_ATTRIBUTE);
            if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                return emailAddress;
            }
            this.log.warn("Using EWS, configured to use mail attribute, and no email address in user attribute {} for user {}. Falling back to constructing one from username", (Object)MAIL_ATTRIBUTE, (Object)accountName);
        }
        String suffix = config.getUsernameSuffix();
        if (accountName != null && StringUtils.isNotBlank((CharSequence)suffix)) {
            return accountName.concat(suffix);
        }
        return accountName;
    }

    protected Credentials createNTCredentials(String ntlmDomain, String username, String password) {
        int index = username.indexOf("@");
        username = index > 0 ? username.substring(0, index) : username;
        return new NTCredentials(username, password, "paramDoesNotSeemToMatter", ntlmDomain);
    }
}

