/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.controller.BaseEmailController;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.exception.MailTimeoutException;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationQuery;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailAccountSummaryController
extends BaseEmailController {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String FORCE_REFRESH_PARAMETER = "forceRefresh";
    public static final String KEY_ACCOUNT_SUMMARY = "accountSummary";
    public static final String KEY_INBOX_URL = "inboxUrl";
    public static final String KEY_ERROR = "error";
    public static final String KEY_EMAIL_QUOTA_LIMIT = "emailQuotaLimit";
    public static final String KEY_EMAIL_QUOTA_USAGE = "emailQuotaUsage";
    public static final String INBOX_NAME_PREFERENCE = "inboxName";
    public static final String INBOX_NAME_DEFAULT = "INBOX";
    public static final String INBOX_NAME_UNDEFINED = "undefined";
    private static final String NOTIFICATION_NAMESPACE = "https://source.jasig.org/schemas/portlet/notification";
    private static final String NOTIFICATION_QUERY_LOCAL_NAME = "NotificationQuery";
    private static final String NOTIFICATION_QUERY_QNAME_STRING = "{https://source.jasig.org/schemas/portlet/notification}NotificationQuery";
    private static final String NOTIFICATION_RESULT_LOCAL_NAME = "NotificationResult";
    private static final QName NOTIFICATION_RESULT_QNAME = new QName("https://source.jasig.org/schemas/portlet/notification", "NotificationResult");
    private static final String CONTEXT_PATH_PREFERENCE = "portal.context.path";
    private static final String NOTIFICATION_REDIRECT_FNAME = "portlet.fname";
    private static final String NOTIFICATION_CATEGORY_NAME = "notification.category.title";
    private static final String NOTIFICATION_ENTRY_NAME = "notification.entry.title";
    private static final String NOTIFICATION_UNREAD_BODY = "notification.entry.body.unread";
    private static final String NOTIFICATION_ENTRY_SOURCE = "notification.entry.source";

    @ResourceMapping(value="accountSummary")
    public ModelAndView getAccountSummary(ResourceRequest req, ResourceResponse res, @RequestParam(value="pageStart") int start, @RequestParam(value="numberOfMessages") int max, @RequestParam(value="inboxFolder", required=false) String folder) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String username = req.getRemoteUser();
        try {
            AccountSummary accountSummary;
            boolean refresh = Boolean.valueOf(req.getParameter(FORCE_REFRESH_PARAMETER));
            if (req.getPortletSession().getAttribute(FORCE_REFRESH_PARAMETER) != null) {
                refresh = true;
                req.getPortletSession().removeAttribute(FORCE_REFRESH_PARAMETER);
            }
            PortletPreferences prefs = req.getPreferences();
            if (folder == null || folder.equals(INBOX_NAME_UNDEFINED)) {
                folder = prefs.getValue(INBOX_NAME_PREFERENCE, INBOX_NAME_DEFAULT);
            }
            String prefFolder = prefs.getValue(INBOX_NAME_PREFERENCE, INBOX_NAME_DEFAULT);
            if (!prefs.isReadOnly(INBOX_NAME_PREFERENCE) && !folder.equals(prefFolder)) {
                prefs.setValue(INBOX_NAME_PREFERENCE, folder);
                prefs.store();
            }
            if ((accountSummary = this.getEmailAccountService((PortletRequest)req).getAccountSummary((PortletRequest)req, start, max, refresh, folder)).isValid()) {
                model.put(KEY_ACCOUNT_SUMMARY, accountSummary);
                model.put(KEY_INBOX_URL, accountSummary.getInboxUrl());
                if (accountSummary.getQuota() == null) {
                    model.put(KEY_EMAIL_QUOTA_USAGE, "-1");
                } else {
                    model.put(KEY_EMAIL_QUOTA_USAGE, accountSummary.getQuota().getUsageAsPercentage());
                    model.put(KEY_EMAIL_QUOTA_LIMIT, accountSummary.getQuota().getLimitAsString());
                }
            } else {
                Throwable cause = accountSummary.getErrorCause();
                if (MailAuthenticationException.class.isAssignableFrom(cause.getClass())) {
                    this.log.info((Object)("Authentication Failure (username='" + username + "') : " + cause.getMessage()));
                    res.setProperty("portlet.http-status-code", Integer.toString(401));
                    model.put(KEY_ERROR, "Not authorized");
                } else {
                    this.log.error((Object)"Unanticipated Error", cause);
                    res.setProperty("portlet.http-status-code", Integer.toString(500));
                    model.put(KEY_ERROR, "Unanticipated Error");
                }
            }
        }
        catch (MailTimeoutException ex) {
            this.log.error((Object)"Mail Service Timeout", (Throwable)ex);
            res.setProperty("portlet.http-status-code", Integer.toString(504));
            model.put(KEY_ERROR, "Mail Service Timeout");
        }
        catch (Exception ex) {
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
            res.setProperty("portlet.http-status-code", Integer.toString(500));
            model.put(KEY_ERROR, "ex.getMessage()");
        }
        return new ModelAndView("json", model);
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationQuery")
    public void syndicateNotifications(EventRequest req, EventResponse res) {
        NotificationQuery query = (NotificationQuery)req.getEvent().getValue();
        this.log.info((Object)("***** Syndicating announcements for Notification portlet with windowId=" + query.getQueryWindowId()));
        long count = this.getUnreadEmail((PortletRequest)req);
        if (count == 0L) {
            this.log.info((Object)("No unread messages for " + req.getRemoteUser()));
            return;
        }
        PortletPreferences prefs = req.getPreferences();
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        NotificationCategory category = new NotificationCategory();
        category.setTitle(prefs.getValue(NOTIFICATION_CATEGORY_NAME, "Email"));
        categories.add(category);
        ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>();
        NotificationEntry entry = new NotificationEntry();
        entry.setTitle(prefs.getValue(NOTIFICATION_ENTRY_NAME, "Unread Email"));
        String body = prefs.getValue(NOTIFICATION_UNREAD_BODY, "You have {} unread email in your preview inbox.");
        entry.setBody(body.replace("{}", Long.toString(count)));
        entry.setSource(prefs.getValue(NOTIFICATION_ENTRY_SOURCE, "Email Preview"));
        entry.setUrl(this.generateUrl((PortletRequest)req));
        entries.add(entry);
        category.setEntries(entries);
        NotificationResponse response = new NotificationResponse();
        response.setCategories(categories);
        NotificationResult result = new NotificationResult();
        result.setQueryWindowId(query.getQueryWindowId());
        result.setResultWindowId(req.getWindowID());
        result.setNotificationResponse(response);
        res.setEvent(NOTIFICATION_RESULT_QNAME, (Serializable)result);
    }

    private String generateUrl(PortletRequest req) {
        String[] parts;
        PortletPreferences prefs = req.getPreferences();
        String contextPath = prefs.getValue(CONTEXT_PATH_PREFERENCE, "uportal");
        String fname = prefs.getValue(NOTIFICATION_REDIRECT_FNAME, "email-preview");
        String subscribeId = "";
        if (req.getWindowID() != null && (parts = req.getWindowID().split("_")) != null && parts.length > 2) {
            subscribeId = "." + parts[1];
        }
        return "/" + contextPath + "/p/" + fname + subscribeId + "/max/render.uP";
    }

    private long getUnreadEmail(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String folder = prefs.getValue(INBOX_NAME_PREFERENCE, INBOX_NAME_DEFAULT);
        AccountSummary accountSummary = this.getEmailAccountService(req).getAccountSummary(req, 0, 1, false, folder);
        return accountSummary.isValid() ? (long)accountSummary.getUnreadMessageCount() : 0L;
    }
}

