/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.javamail;

import com.sun.mail.imap.IMAPFolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Quota;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.EmailQuota;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IMailAccountDao;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.service.ICredentialsProvider;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public final class JavamailAccountDaoImpl
implements IMailAccountDao {
    private static final String CONTENT_TYPE_ATTACHMENTS_PATTERN = "multipart/mixed;";
    private static final String INTERNET_ADDRESS_TYPE = "rfc822";
    @Autowired(required=true)
    private ILinkServiceRegistry linkServiceRegistry;
    @Autowired
    private ICredentialsProvider credentialsProvider;
    private boolean debug = false;
    private String filePath = "classpath:antisamy.xml";
    @Autowired(required=true)
    private ApplicationContext ctx;
    private Policy policy;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void setCredentialsProvider(ICredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setSecurityFile(String path) {
        this.filePath = path;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        InputStream stream = this.ctx.getResource(this.filePath).getInputStream();
        this.policy = Policy.getInstance((InputStream)stream);
    }

    public AccountSummary fetchAccountSummaryFromStore(MailStoreConfiguration config, String username, String mailAccount, String folder, int start, int max) {
        Authenticator auth = this.credentialsProvider.getAuthenticator();
        Folder inbox = null;
        try {
            Session session = this.openMailSession(config, auth);
            inbox = this.getUserInbox(session, folder);
            inbox.open(1);
            long startTime = System.currentTimeMillis();
            List messages = this.getEmailMessages(inbox, start, max, session);
            if (this.log.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                int messagesToDisplayCount = messages.size();
                this.log.debug("Finished looking up email messages. Inbox size: " + inbox.getMessageCount() + " Unread message count: " + inbox.getUnreadMessageCount() + " Total elapsed time: " + elapsedTime + "ms " + " Time per message in inbox: " + (inbox.getMessageCount() == 0 ? 0L : elapsedTime / (long)inbox.getMessageCount()) + "ms" + " Time per displayed message: " + (messagesToDisplayCount == 0 ? 0L : elapsedTime / (long)messagesToDisplayCount) + "ms");
            }
            IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
            String inboxUrl = null;
            if (linkService != null) {
                inboxUrl = linkService.getInboxUrl(config);
            }
            AccountSummary summary = new AccountSummary(inboxUrl, messages, inbox.getUnreadMessageCount(), inbox.getMessageCount(), start, max, this.isDeleteSupported(inbox), this.getQuota(inbox));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Successfully retrieved email AccountSummary");
            }
            AccountSummary accountSummary = summary;
            return accountSummary;
        }
        catch (MailAuthenticationException mae) {
            AccountSummary accountSummary = new AccountSummary((Throwable)mae);
            return accountSummary;
        }
        catch (MessagingException me) {
            this.log.error("Exception encountered while retrieving account info", (Throwable)me);
            throw new EmailPreviewException((Throwable)me);
        }
        catch (IOException e) {
            this.log.error("Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        catch (ScanException e) {
            this.log.error("Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error("Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail store connection");
                }
            }
        }
    }

    private Session openMailSession(MailStoreConfiguration config, Authenticator auth) {
        int timeout;
        if (config == null) {
            String msg = "Argument 'config' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (auth == null) {
            String msg = "Argument 'auth' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        Properties mailProperties = new Properties();
        mailProperties.put("mail.store.protocol", config.getProtocol());
        mailProperties.put("mail.host", config.getHost());
        mailProperties.put("mail.port", (Object)config.getPort());
        mailProperties.put("mail.debug", this.debug ? "true" : "false");
        String protocolPropertyPrefix = "mail." + config.getProtocol() + ".";
        int connectionTimeout = config.getConnectionTimeout();
        if (connectionTimeout >= 0) {
            mailProperties.put(protocolPropertyPrefix + "connectiontimeout", (Object)connectionTimeout);
        }
        if ((timeout = config.getTimeout()) >= 0) {
            mailProperties.put(protocolPropertyPrefix + "timeout", (Object)timeout);
        }
        for (Map.Entry property : config.getJavaMailProperties().entrySet()) {
            mailProperties.put(property.getKey(), property.getValue());
        }
        return Session.getInstance((Properties)mailProperties, (Authenticator)auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailMessage getMessage(MailStoreConfiguration config, String messageId) {
        Authenticator auth = this.credentialsProvider.getAuthenticator();
        Folder inbox = null;
        try {
            boolean unread;
            int mode = config.getMarkMessagesAsRead() ? 2 : 1;
            Session session = this.openMailSession(config, auth);
            inbox = this.getUserInbox(session, config.getInboxFolderName());
            inbox.open(mode);
            Message message = inbox instanceof UIDFolder ? ((UIDFolder)inbox).getMessageByUID(Long.parseLong(messageId)) : inbox.getMessage(Integer.parseInt(messageId));
            boolean bl = unread = !message.isSet(Flags.Flag.SEEN);
            if (config.getMarkMessagesAsRead()) {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            EmailMessage emailMessage = this.wrapMessage(message, true, session);
            if (!config.getMarkMessagesAsRead()) {
                emailMessage.setUnread(unread);
            }
            EmailMessage emailMessage2 = emailMessage;
            return emailMessage2;
        }
        catch (MessagingException e) {
            this.log.error("Messaging exception while retrieving individual message", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("IO exception while retrieving individual message", (Throwable)e);
        }
        catch (ScanException e) {
            this.log.error("AntiSamy scanning exception while retrieving individual message", (Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error("AntiSamy policy exception while retrieving individual message", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail store connection");
                }
            }
        }
        return null;
    }

    private Folder getUserInbox(Session session, String folderName) throws MessagingException {
        if (session == null) {
            String msg = "Argument 'session' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        try {
            Store store = session.getStore();
            store.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mail store connection established to get user inbox");
            }
            Folder root = store.getDefaultFolder();
            Folder inboxFolder = root.getFolder(folderName);
            return inboxFolder;
        }
        catch (AuthenticationFailedException e) {
            throw new MailAuthenticationException((Throwable)e);
        }
    }

    private EmailMessage wrapMessage(Message msg, boolean populateContent, Session session) throws MessagingException, IOException, ScanException, PolicyException {
        String subject = msg.getSubject();
        if (!StringUtils.isBlank((CharSequence)subject)) {
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(subject, this.policy);
            subject = cr.getCleanHTML();
        }
        EmailMessageContent msgContent = null;
        if (populateContent) {
            try {
                msgContent = this.getMessageContent(msg.getContent(), msg.getContentType());
            }
            catch (MessagingException me) {
                this.log.debug("Difficulty reading a message (digitally signed?). Attempting workaround...");
                try {
                    MimeMessage mm = (MimeMessage)msg;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    mm.writeTo((OutputStream)bos);
                    bos.close();
                    SharedByteArrayInputStream bis = new SharedByteArrayInputStream(bos.toByteArray());
                    MimeMessage copy = new MimeMessage(session, (InputStream)bis);
                    bis.close();
                    msgContent = this.getMessageContent(copy.getContent(), copy.getContentType());
                }
                catch (Throwable t) {
                    this.log.error("Failed to read message body", t);
                    msgContent = new EmailMessageContent("UNABLE TO READ MESSAGE BODY: " + t.getMessage(), false);
                }
            }
            String content = msgContent.getContentString();
            if (!StringUtils.isBlank((CharSequence)content)) {
                AntiSamy as = new AntiSamy();
                CleanResults cr = as.scan(content, this.policy);
                content = cr.getCleanHTML();
            }
            msgContent.setContentString(content);
        }
        int messageNumber = msg.getMessageNumber();
        String uid = null;
        if (msg.getFolder() instanceof UIDFolder) {
            uid = Long.toString(((UIDFolder)msg.getFolder()).getUID(msg));
        }
        Address[] addr = msg.getFrom();
        String sender = this.getFormattedAddresses(addr);
        Date sentDate = msg.getSentDate();
        boolean unread = !msg.isSet(Flags.Flag.SEEN);
        boolean answered = msg.isSet(Flags.Flag.ANSWERED);
        boolean deleted = msg.isSet(Flags.Flag.DELETED);
        boolean multipart = false;
        String contentType = null;
        try {
            multipart = msg.getContentType().toLowerCase().startsWith(CONTENT_TYPE_ATTACHMENTS_PATTERN);
            contentType = msg.getContentType();
        }
        catch (MessagingException me) {
            this.log.debug("Message content unavailable (digitally signed?);  message will appear in the preview table correctly, but the body will not be viewable");
            this.log.trace(me.getMessage(), (Throwable)me);
        }
        String to = this.getTo(msg);
        String cc = this.getCc(msg);
        String bcc = this.getBcc(msg);
        return new EmailMessage(messageNumber, uid, sender, subject, sentDate, unread, answered, deleted, multipart, contentType, msgContent, to, cc, bcc);
    }

    private List<EmailMessage> getEmailMessages(Folder mailFolder, int pageStart, int messageCount, Session session) throws MessagingException, IOException, ScanException, PolicyException {
        int totalMessageCount = mailFolder.getMessageCount();
        int start = Math.max(1, totalMessageCount - pageStart - (messageCount - 1));
        int end = Math.max(totalMessageCount - pageStart, 1);
        Message[] messages = totalMessageCount != 0 ? mailFolder.getMessages(start, end) : new Message[]{};
        long startTime = System.currentTimeMillis();
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        profile.add(FetchProfile.Item.FLAGS);
        profile.add(FetchProfile.Item.CONTENT_INFO);
        if (mailFolder instanceof UIDFolder) {
            profile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        }
        mailFolder.fetch(messages, profile);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Time elapsed while fetching message headers; {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        LinkedList<EmailMessage> emails = new LinkedList<EmailMessage>();
        for (Message currentMessage : messages) {
            EmailMessage emailMessage = this.wrapMessage(currentMessage, false, session);
            emails.add(emailMessage);
        }
        Collections.reverse(emails);
        return emails;
    }

    private EmailMessageContent getMessageContent(Object content, String mimeType) throws IOException, MessagingException {
        if (content instanceof String) {
            return new EmailMessageContent((String)content, this.isHtml(mimeType));
        }
        if (content instanceof MimeMultipart) {
            Multipart m = (Multipart)content;
            int parts = m.getCount();
            for (int i = parts - 1; i >= 0; --i) {
                EmailMessageContent result = null;
                BodyPart part = m.getBodyPart(i);
                Object partContent = part.getContent();
                String contentType = part.getContentType();
                boolean isHtml = this.isHtml(contentType);
                this.log.debug("Examining Multipart " + i + " with type " + contentType + " and class " + partContent.getClass());
                if (partContent instanceof String) {
                    result = new EmailMessageContent((String)partContent, isHtml);
                } else if (partContent instanceof InputStream && contentType.startsWith("text/html")) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)((InputStream)partContent), (Writer)writer);
                    result = new EmailMessageContent(writer.toString(), isHtml);
                } else if (partContent instanceof MimeMultipart) {
                    result = this.getMessageContent(partContent, contentType);
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean isHtml(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return (mimeType = mimeType.trim().toLowerCase()).contains("text/html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteMessages(MailStoreConfiguration config, String[] uuids) {
        Authenticator auth = this.credentialsProvider.getAuthenticator();
        Folder inbox = null;
        try {
            Session session = this.openMailSession(config, auth);
            inbox = this.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Delete feature is supported only for UIDFolder instances";
                throw new UnsupportedOperationException(msg);
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(this.getMessageUidsAsLong(uuids));
            inbox.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error("Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail store connection");
                }
            }
        }
        return false;
    }

    private long[] getMessageUidsAsLong(String[] messageIds) {
        long[] ids = new long[messageIds.length];
        int i = 0;
        for (String id : messageIds) {
            ids[i++] = Long.parseLong(id);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMessageReadStatus(MailStoreConfiguration config, String[] uuids, boolean read) {
        Authenticator auth = this.credentialsProvider.getAuthenticator();
        Folder inbox = null;
        try {
            Session session = this.openMailSession(config, auth);
            inbox = this.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Toggle unread feature is supported only for UIDFolder instances";
                this.log.info(msg);
                boolean bl = false;
                return bl;
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(this.getMessageUidsAsLong(uuids));
            inbox.setFlags(msgs, new Flags(Flags.Flag.SEEN), read);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error("Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail store connection");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Folder> getAllUserInboxFolders(MailStoreConfiguration config) {
        Authenticator auth = this.credentialsProvider.getAuthenticator();
        Store store = null;
        try {
            Session session = this.openMailSession(config, auth);
            if (session == null) {
                String msg = "Argument 'session' cannot be null";
                throw new IllegalArgumentException(msg);
            }
            store = session.getStore();
            store.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mail store connection established to get all user inbox folders");
            }
            List<Folder> list = Arrays.asList(store.getDefaultFolder().list("*"));
            return list;
        }
        catch (Exception e) {
            this.log.error("Can't get all user Inbox folders");
            List<Folder> list = null;
            return list;
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (Exception e) {
                    this.log.warn("Can't close correctly javamail store connection");
                }
            }
        }
    }

    private boolean isDeleteSupported(Folder f) {
        return f instanceof UIDFolder;
    }

    private EmailQuota getQuota(Folder folder) {
        if (!(folder instanceof IMAPFolder)) {
            return null;
        }
        try {
            if (folder.exists() && folder.getMessageCount() > 0) {
                Quota[] quotas;
                for (Quota quota : quotas = ((IMAPFolder)folder).getQuota()) {
                    for (Quota.Resource resource : quota.resources) {
                        if (!resource.name.equals("STORAGE")) continue;
                        return new EmailQuota(resource.limit, resource.usage);
                    }
                }
            }
        }
        catch (MessagingException e) {
            this.log.error("Failed to connect or get quota for mail user ");
        }
        return null;
    }

    private String getTo(Message message) throws MessagingException {
        Address[] toRecipients = message.getRecipients(Message.RecipientType.TO);
        return this.getFormattedAddresses(toRecipients);
    }

    private String getCc(Message message) throws MessagingException {
        Address[] ccRecipients = message.getRecipients(Message.RecipientType.CC);
        return this.getFormattedAddresses(ccRecipients);
    }

    private String getBcc(Message message) throws MessagingException {
        Address[] bccRecipients = message.getRecipients(Message.RecipientType.BCC);
        return this.getFormattedAddresses(bccRecipients);
    }

    private String getFormattedAddresses(Address[] addresses) {
        ArrayList<String> recipientsList = new ArrayList<String>();
        String receiver = null;
        if (addresses != null && addresses.length != 0) {
            for (Address adress : addresses) {
                if (INTERNET_ADDRESS_TYPE.equals(adress.getType())) {
                    InternetAddress inet = (InternetAddress)adress;
                    receiver = inet.toUnicodeString();
                } else {
                    receiver = adress.toString();
                }
                recipientsList.add(receiver);
            }
        }
        return StringUtils.join(recipientsList, (String)"; ").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

