/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.twitter.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.log4j.Logger;
import org.esupportail.twitter.beans.OAuthTwitterConfig;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.social.RejectedAuthorizationException;
import org.springframework.stereotype.Service;

@Service
public class OAuthTwitterApplicationOnlyService
implements InitializingBean {
    private static Logger log = Logger.getLogger(OAuthTwitterApplicationOnlyService.class);
    static final String URL_TWITTER_OAUTH2_TOKEN = "https://api.twitter.com/oauth2/token";
    static final String ESUPTWITTER_USERAGENT = "EsupTwitter";
    @Autowired
    protected OAuthTwitterConfig oAuthTwitterConfig;
    protected String applicationOnlyBearerToken;

    public String getApplicationOnlyBearerToken() {
        return this.applicationOnlyBearerToken;
    }

    private String encodeKeys(String consumerKey, String consumerSecret) {
        try {
            String encodedConsumerKey = URLEncoder.encode(consumerKey, "UTF-8");
            String encodedConsumerSecret = URLEncoder.encode(consumerSecret, "UTF-8");
            String fullKey = encodedConsumerKey + ":" + encodedConsumerSecret;
            byte[] encodedBytes = Base64.encode((byte[])fullKey.getBytes());
            return new String(encodedBytes);
        }
        catch (UnsupportedEncodingException e) {
            return new String();
        }
    }

    public void afterPropertiesSet() throws Exception {
        HttpURLConnection connection = null;
        String encodedCredentials = this.encodeKeys(this.oAuthTwitterConfig.getConsumerKey(), this.oAuthTwitterConfig.getConsumerSecret());
        try {
            URL url = new URL(URL_TWITTER_OAUTH2_TOKEN);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Host", "api.twitter.com");
            connection.setRequestProperty("User-Agent", ESUPTWITTER_USERAGENT);
            connection.setRequestProperty("Authorization", "Basic " + encodedCredentials);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setRequestProperty("Content-Length", "29");
            connection.setUseCaches(false);
            OAuthTwitterApplicationOnlyService.writeRequest(connection, "grant_type=client_credentials");
            String jsonResponse = OAuthTwitterApplicationOnlyService.readResponse(connection);
            log.debug((Object)("jsonResponse of the bearer oauth request : " + jsonResponse));
            if (connection.getResponseCode() == 403) {
                log.error((Object)"HTTP 403 (Forbidden) returned from Twitter API call for bearer token. Check values of Consumer Key and Consumer Secret in tokens.properties");
                throw new RejectedAuthorizationException("HTTP 403 (Forbidden) returned attempting to get Twitter API bearer token");
            }
            JSONObject obj = new JSONObject(jsonResponse);
            if (obj != null) {
                this.applicationOnlyBearerToken = (String)obj.get("access_token");
            }
        }
        catch (MalformedURLException e) {
            throw new IOException("Invalid endpoint URL specified.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static boolean writeRequest(HttpURLConnection connection, String textBody) {
        try {
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            wr.write(textBody);
            wr.flush();
            wr.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String readResponse(HttpURLConnection connection) {
        try {
            StringBuilder str = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = "";
            while ((line = br.readLine()) != null) {
                str.append(line + System.getProperty("line.separator"));
            }
            return str.toString();
        }
        catch (IOException e) {
            return new String();
        }
    }
}

