/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.twitter.web;

import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.log4j.Logger;
import org.esupportail.twitter.beans.OAuthTwitterConfig;
import org.esupportail.twitter.services.OAuthTwitterApplicationOnlyService;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.impl.TwitterTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;

@Controller
public class TwitterController
implements InitializingBean {
    private static Logger log = Logger.getLogger(TwitterController.class);
    private static final String PREF_TWITTER_USERNAME = "twitterUsername";
    private static final String DEFAULT_TWITTER_USERNAME = "lavillederouen";
    private static final String PREF_TWITTER_USER_TOKEN = "twitterUserToken";
    private static final String PREF_TWITTER_USER_SECRET = "twitterUserSecret";
    private static final String PREF_TWITTER_TWEETS_NUMBER = "twitterTweetsNumber";
    @Autowired
    protected OAuthTwitterConfig oAuthTwitterConfig;
    @Autowired
    OAuthTwitterApplicationOnlyService oAuthTwitterApplicationOnlyService;
    protected OAuthService service;

    public void afterPropertiesSet() throws Exception {
        if (this.oAuthTwitterConfig != null && !this.oAuthTwitterConfig.getConsumerKey().isEmpty() && !this.oAuthTwitterConfig.getConsumerSecret().isEmpty()) {
            this.service = new ServiceBuilder().provider(TwitterApi.SSL.class).apiKey(this.oAuthTwitterConfig.getConsumerKey()).apiSecret(this.oAuthTwitterConfig.getConsumerSecret()).build();
        } else {
            new Exception("You have to setup twitterConfig.xml and register your EsupTwitter on https://dev.twitter.com/apps");
        }
    }

    public boolean isOAuthEnabled() {
        return this.service != null;
    }

    @RequestMapping(value={"VIEW"})
    protected ModelAndView renderView(RenderRequest request, RenderResponse response) throws Exception {
        List tweetList;
        TwitterProfile twitterProfile;
        ModelMap model = new ModelMap();
        PortletPreferences prefs = request.getPreferences();
        String twitterUsername = prefs.getValue(PREF_TWITTER_USERNAME, DEFAULT_TWITTER_USERNAME);
        String applicationOnlyBearerToken = this.oAuthTwitterApplicationOnlyService.getApplicationOnlyBearerToken();
        String twitterUserToken = prefs.getValue(PREF_TWITTER_USER_TOKEN, null);
        String twitterUserSecret = prefs.getValue(PREF_TWITTER_USER_SECRET, null);
        int tweetsNumber = new Integer(prefs.getValue(PREF_TWITTER_TWEETS_NUMBER, "-1"));
        log.debug((Object)("twitterUserToken:" + twitterUserToken));
        log.debug((Object)("twitterUserSecret:" + twitterUserSecret));
        if (twitterUserToken != null && twitterUserSecret != null) {
            TwitterTemplate twitter = new TwitterTemplate(this.oAuthTwitterConfig.getConsumerKey(), this.oAuthTwitterConfig.getConsumerSecret(), twitterUserToken, twitterUserSecret);
            twitterProfile = twitter.userOperations().getUserProfile();
            tweetList = twitter.timelineOperations().getHomeTimeline(tweetsNumber);
        } else {
            TwitterTemplate twitter = new TwitterTemplate(applicationOnlyBearerToken);
            twitterProfile = twitter.userOperations().getUserProfile(twitterUsername);
            tweetList = twitter.timelineOperations().getUserTimeline(twitterUsername, tweetsNumber);
        }
        model.put((Object)"tweetList", (Object)tweetList);
        model.put((Object)"twitterProfile", (Object)twitterProfile);
        response.setTitle("Twitter " + twitterProfile.getScreenName());
        return new ModelAndView("view", (Map)model);
    }

    @RequestMapping(value={"EDIT"})
    public ModelAndView renderEditView(RenderRequest request, RenderResponse response) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        ModelMap model = new ModelMap();
        if (this.isOAuthEnabled()) {
            Token requestToken = this.service.getRequestToken();
            String twitterAccessToken = requestToken.getToken();
            String twitterAccessTokenSecret = requestToken.getSecret();
            model.put((Object)"twitterAccessToken", (Object)twitterAccessToken);
            model.put((Object)"twitterAccessTokenSecret", (Object)twitterAccessTokenSecret);
        }
        String currentTwitterUsername = prefs.getValue(PREF_TWITTER_USERNAME, DEFAULT_TWITTER_USERNAME);
        boolean connected = false;
        String twitterUserToken = prefs.getValue(PREF_TWITTER_USER_TOKEN, null);
        String twitterUserSecret = prefs.getValue(PREF_TWITTER_USER_SECRET, null);
        String twitterTweetsNumber = prefs.getValue(PREF_TWITTER_TWEETS_NUMBER, "-1");
        if (twitterUserToken != null) {
            TwitterTemplate twitter = new TwitterTemplate(this.oAuthTwitterConfig.getConsumerKey(), this.oAuthTwitterConfig.getConsumerSecret(), twitterUserToken, twitterUserSecret);
            TwitterProfile twitterProfile = twitter.userOperations().getUserProfile();
            currentTwitterUsername = twitterProfile.getName();
            connected = true;
        }
        model.put((Object)"isOAuthEnabled", (Object)this.isOAuthEnabled());
        model.put((Object)"currentTwitterUsername", (Object)currentTwitterUsername);
        model.put((Object)"connectedMode", (Object)connected);
        model.put((Object)PREF_TWITTER_TWEETS_NUMBER, (Object)twitterTweetsNumber);
        return new ModelAndView("edit", (Map)model);
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterUsername"})
    public void setTwitterUsername(@RequestParam(value="twitterUsername", required=true) String twitterUsername, ActionRequest request, ActionResponse response) throws Exception {
        if (StringUtils.hasText((String)twitterUsername) && StringUtils.hasLength((String)twitterUsername)) {
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(PREF_TWITTER_USER_TOKEN, null);
            prefs.setValue(PREF_TWITTER_USER_SECRET, null);
            prefs.setValue(PREF_TWITTER_USERNAME, twitterUsername);
            prefs.store();
        }
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterPin"})
    public void setTwitterPin(@RequestParam(value="twitterAccessToken", required=true) String twitterAccessToken, @RequestParam(value="twitterAccessTokenSecret", required=true) String twitterAccessTokenSecret, @RequestParam(value="twitterPin", required=true) String twitterPin, ActionRequest request, ActionResponse response) throws Exception {
        Verifier verifier = new Verifier(twitterPin);
        Token requestToken = new Token(twitterAccessToken, twitterAccessTokenSecret);
        Token accessToken = null;
        try {
            accessToken = this.service.getAccessToken(requestToken, verifier);
        }
        catch (Exception ex) {
            log.info((Object)"pb retrieving accessToken : maybe the user put a wrong pin code");
            log.debug((Object)("exception when retrieving accessToken : " + ex.getMessage()), (Throwable)ex);
        }
        if (accessToken != null) {
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(PREF_TWITTER_USERNAME, "");
            prefs.setValue(PREF_TWITTER_USER_TOKEN, accessToken.getToken());
            prefs.setValue(PREF_TWITTER_USER_SECRET, accessToken.getSecret());
            prefs.store();
        }
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterTweetsNumber"})
    public void setTwitterTweetsNumber(@RequestParam(value="twitterTweetsNumber", required=true) String twitterTweetsNumber, ActionRequest request, ActionResponse response) throws Exception {
        if (StringUtils.hasText((String)twitterTweetsNumber) && StringUtils.hasLength((String)twitterTweetsNumber)) {
            int twitterTweetsNumberInt = -1;
            try {
                twitterTweetsNumberInt = new Integer(twitterTweetsNumber);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (twitterTweetsNumberInt > 0) {
                PortletPreferences prefs = request.getPreferences();
                prefs.setValue(PREF_TWITTER_TWEETS_NUMBER, twitterTweetsNumber);
                prefs.store();
            }
        }
    }

    @RequestMapping(value={"ABOUT"})
    public ModelAndView renderAboutView(RenderRequest request, RenderResponse response) throws Exception {
        ModelMap model = new ModelMap();
        return new ModelAndView("about", (Map)model);
    }

    @RequestMapping(value={"HELP"})
    public ModelAndView renderHelpView(RenderRequest request, RenderResponse response) throws Exception {
        ModelMap model = new ModelMap();
        return new ModelAndView("help", (Map)model);
    }
}

