/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.twitter.web;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;
import org.esupportail.twitter.beans.OAuthTwitterConfig;
import org.esupportail.twitter.beans.User;
import org.esupportail.twitter.xstream.EsupXStreamMarshaller;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.portlet.ModelAndView;

@Controller
public class TwitterController
implements InitializingBean {
    private static Logger log = Logger.getLogger(TwitterController.class);
    private static final String PREF_TWITTER_USERNAME = "twitterUsername";
    private static final String DEFAULT_TWITTER_USERNAME = "lavillederouen";
    private static final String PREF_TWITTER_USER_TOKEN = "twitterUserToken";
    private static final String PREF_TWITTER_USER_SECRET = "twitterUserSecret";
    private static final String PREF_TWITTER_TWEETS_NUMBER = "twitterTweetsNumber";
    @Autowired
    protected OAuthTwitterConfig oAuthTwitterConfig;
    private RestTemplate restTemplate;
    @Autowired
    protected EsupXStreamMarshaller marshaller;
    protected OAuthService service;

    @Autowired
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        CommonsClientHttpRequestFactory factory = (CommonsClientHttpRequestFactory)restTemplate.getRequestFactory();
        HttpClient client = factory.getHttpClient();
        client.getParams().setCookiePolicy("compatibility");
        client.getParams().setSoTimeout(50000);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.oAuthTwitterConfig != null && !this.oAuthTwitterConfig.getConsumerKey().isEmpty() && !this.oAuthTwitterConfig.getConsumerSecret().isEmpty()) {
            this.service = new ServiceBuilder().provider(TwitterApi.class).apiKey(this.oAuthTwitterConfig.getConsumerKey()).apiSecret(this.oAuthTwitterConfig.getConsumerSecret()).build();
        }
    }

    public boolean isOAuthEnabled() {
        return this.service != null;
    }

    @RequestMapping(value={"VIEW"})
    protected ModelAndView renderView(RenderRequest request, RenderResponse response) throws Exception {
        ModelMap model = new ModelMap();
        PortletPreferences prefs = request.getPreferences();
        String twitterUsername = prefs.getValue(PREF_TWITTER_USERNAME, DEFAULT_TWITTER_USERNAME);
        String twitterUserToken = prefs.getValue(PREF_TWITTER_USER_TOKEN, null);
        String twitterUserSecret = prefs.getValue(PREF_TWITTER_USER_SECRET, null);
        int tweetsNumber = new Integer(prefs.getValue(PREF_TWITTER_TWEETS_NUMBER, "-1"));
        if (!this.isOAuthEnabled() || twitterUserToken == null || !StringUtils.hasLength((String)twitterUserToken)) {
            try {
                User user = (User)this.restTemplate.getForObject("http://api.twitter.com/1/users/show/{username}.xml", User.class, new Object[]{twitterUsername});
                List statusList = (List)this.restTemplate.getForObject("http://api.twitter.com/1/statuses/user_timeline.xml?id={username}", ArrayList.class, new Object[]{twitterUsername});
                tweetsNumber = tweetsNumber == -1 ? statusList.size() : Math.min(tweetsNumber, statusList.size());
                statusList = statusList.subList(0, tweetsNumber);
                model.put((Object)"user", (Object)user);
                model.put((Object)"statusList", statusList);
                response.setTitle("Twitter " + user.getScreen_name());
            }
            catch (HttpClientErrorException e) {
                return new ModelAndView("error", (Map)model);
            }
        } else {
            log.debug((Object)("twitterUserToken:" + twitterUserToken));
            log.debug((Object)("twitterUserSecret:" + twitterUserSecret));
            Token accessToken = new Token(twitterUserToken, twitterUserSecret);
            if (accessToken != null) {
                String twitterUserUrl = "http://api.twitter.com/1/account/verify_credentials.xml";
                String responseBodyUser = this.requestTwitterUrl(accessToken, twitterUserUrl);
                User user = (User)this.marshaller.unmarshal(new StreamSource(new StringReader(responseBodyUser.toString())));
                String twitterstatusListUrl = "http://api.twitter.com/1/statuses/home_timeline.xml";
                String responseBodyStatusList = this.requestTwitterUrl(accessToken, twitterstatusListUrl);
                List statusList = (List)this.marshaller.unmarshal(new StreamSource(new StringReader(responseBodyStatusList.toString())));
                tweetsNumber = tweetsNumber == -1 ? statusList.size() : Math.min(tweetsNumber, statusList.size());
                statusList = statusList.subList(0, tweetsNumber);
                model.put((Object)"user", (Object)user);
                model.put((Object)"statusList", statusList);
                response.setTitle("Twitter " + user.getScreen_name());
            } else {
                return new ModelAndView("error", (Map)model);
            }
        }
        return new ModelAndView("view", (Map)model);
    }

    private String requestTwitterUrl(Token accessToken, String protectedUrl) {
        OAuthRequest request = new OAuthRequest(Verb.GET, protectedUrl);
        this.service.signRequest(accessToken, request);
        Response response = request.send();
        return response.getBody();
    }

    @RequestMapping(value={"EDIT"})
    public ModelAndView renderEditView(RenderRequest request, RenderResponse response) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        ModelMap model = new ModelMap();
        if (this.isOAuthEnabled()) {
            Token requestToken = this.service.getRequestToken();
            String twitterAccessToken = requestToken.getToken();
            String twitterAccessTokenSecret = requestToken.getSecret();
            model.put((Object)"twitterAccessToken", (Object)twitterAccessToken);
            model.put((Object)"twitterAccessTokenSecret", (Object)twitterAccessTokenSecret);
        }
        String currentTwitterUsername = prefs.getValue(PREF_TWITTER_USERNAME, DEFAULT_TWITTER_USERNAME);
        boolean connected = false;
        String twitterUserToken = prefs.getValue(PREF_TWITTER_USER_TOKEN, null);
        String twitterUserSecret = prefs.getValue(PREF_TWITTER_USER_SECRET, null);
        String twitterTweetsNumber = prefs.getValue(PREF_TWITTER_TWEETS_NUMBER, "-1");
        if (twitterUserToken != null) {
            Token accessToken = new Token(twitterUserToken, twitterUserSecret);
            String twitterUserUrl = "http://api.twitter.com/1/account/verify_credentials.xml";
            String responseBodyUser = this.requestTwitterUrl(accessToken, twitterUserUrl);
            User user = (User)this.marshaller.unmarshal(new StreamSource(new StringReader(responseBodyUser.toString())));
            currentTwitterUsername = user.getName();
            connected = true;
        }
        model.put((Object)"isOAuthEnabled", (Object)this.isOAuthEnabled());
        model.put((Object)"currentTwitterUsername", (Object)currentTwitterUsername);
        model.put((Object)"connectedMode", (Object)connected);
        model.put((Object)PREF_TWITTER_TWEETS_NUMBER, (Object)twitterTweetsNumber);
        return new ModelAndView("edit", (Map)model);
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterUsername"})
    public void setTwitterUsername(@RequestParam(value="twitterUsername", required=true) String twitterUsername, ActionRequest request, ActionResponse response) throws Exception {
        if (StringUtils.hasText((String)twitterUsername) && StringUtils.hasLength((String)twitterUsername)) {
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(PREF_TWITTER_USER_TOKEN, null);
            prefs.setValue(PREF_TWITTER_USER_SECRET, null);
            prefs.setValue(PREF_TWITTER_USERNAME, twitterUsername);
            prefs.store();
        }
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterPin"})
    public void setTwitterPin(@RequestParam(value="twitterAccessToken", required=true) String twitterAccessToken, @RequestParam(value="twitterAccessTokenSecret", required=true) String twitterAccessTokenSecret, @RequestParam(value="twitterPin", required=true) String twitterPin, ActionRequest request, ActionResponse response) throws Exception {
        Verifier verifier = new Verifier(twitterPin);
        Token requestToken = new Token(twitterAccessToken, twitterAccessTokenSecret);
        Token accessToken = null;
        try {
            accessToken = this.service.getAccessToken(requestToken, verifier);
        }
        catch (Exception ex) {
            log.info((Object)"pb retrieving accessToken : maybe the user put a wrong pin code");
            log.debug((Object)("exception when retrieving accessToken : " + ex.getMessage()), (Throwable)ex);
        }
        if (accessToken != null) {
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(PREF_TWITTER_USERNAME, "");
            prefs.setValue(PREF_TWITTER_USER_TOKEN, accessToken.getToken());
            prefs.setValue(PREF_TWITTER_USER_SECRET, accessToken.getSecret());
            prefs.store();
        }
    }

    @RequestMapping(value={"EDIT"}, params={"action=setTwitterTweetsNumber"})
    public void setTwitterTweetsNumber(@RequestParam(value="twitterTweetsNumber", required=true) String twitterTweetsNumber, ActionRequest request, ActionResponse response) throws Exception {
        if (StringUtils.hasText((String)twitterTweetsNumber) && StringUtils.hasLength((String)twitterTweetsNumber)) {
            int twitterTweetsNumberInt = -1;
            try {
                twitterTweetsNumberInt = new Integer(twitterTweetsNumber);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (twitterTweetsNumberInt > 0) {
                PortletPreferences prefs = request.getPreferences();
                prefs.setValue(PREF_TWITTER_TWEETS_NUMBER, twitterTweetsNumber);
                prefs.store();
            }
        }
    }

    @RequestMapping(value={"ABOUT"})
    public ModelAndView renderAboutView(RenderRequest request, RenderResponse response) throws Exception {
        ModelMap model = new ModelMap();
        return new ModelAndView("about", (Map)model);
    }

    @RequestMapping(value={"HELP"})
    public ModelAndView renderHelpView(RenderRequest request, RenderResponse response) throws Exception {
        ModelMap model = new ModelMap();
        return new ModelAndView("help", (Map)model);
    }
}

