/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.rome;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.service.AbstractCachingAlertService;
import org.jasig.portlet.widget.service.IAlert;
import org.jasig.portlet.widget.service.rome.TimestampAlert;
import org.springframework.util.Assert;

public class RomeAlertService
extends AbstractCachingAlertService {
    public static final String URL_PREFERENCE = "RomeAlertService.url";
    private static final Object NO_FURTHER_INFORMATION = "No further information is available.";

    protected List<IAlert> getFeedFromSource(PortletRequest req) {
        ArrayList<TimestampAlert> rslt = new ArrayList<TimestampAlert>();
        PortletPreferences prefs = req.getPreferences();
        String urlPref = prefs.getValue(URL_PREFERENCE, null);
        Assert.hasText((String)urlPref, (String)"Preference RomeAlertService.url must be set");
        try {
            URL url = new URL(urlPref);
            XmlReader reader = new XmlReader(url);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)reader);
            List entries = feed.getEntries();
            for (SyndEntry y : entries) {
                String header = y.getTitle();
                StringBuilder body = new StringBuilder();
                SyndContent desc = y.getDescription();
                if (desc != null) {
                    body.append(desc.getValue());
                }
                if (body.length() == 0) {
                    List contents = y.getContents();
                    for (SyndContent c : contents) {
                        body.append(c.getValue());
                    }
                }
                if (body.length() == 0) {
                    body.append(NO_FURTHER_INFORMATION);
                }
                String link = y.getLink();
                long timestamp = y.getPublishedDate().getTime();
                rslt.add(new TimestampAlert(header, body.toString(), link, timestamp));
            }
            Collections.sort(rslt);
            Collections.reverse(rslt);
        }
        catch (Exception e) {
            String msg = "Unable to read the specified feed:  " + urlPref;
            throw new RuntimeException(msg, e);
        }
        return new ArrayList<IAlert>(rslt);
    }
}

