/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc.app;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.WindowStateException;
import org.jasig.portlet.widget.mvc.app.AppDefinition;
import org.jasig.portlet.widget.mvc.app.AppLauncherConfigController;
import org.jasig.portlet.widget.service.IExpressionProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AppLauncherViewController {
    private static final String WINDOW_STATE_DETACHED = "detached";
    private static final String JSP_ICON = "app/icon";
    private static final String JSP_DETACHED = "app/detached";
    private static final String PREFERENCE_ICON_SIZE_PIXELS = "AppLauncherPortletController.iconSizePixels";
    private static final String DEFAULT_ICON_SIZE_PIXELS = "200";
    private IExpressionProcessor expressionProcessor;

    @Autowired
    public void setExpressionProcessor(IExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    @RenderMapping
    public String view(PortletRequest req) throws Exception {
        AppLauncherConfigController.clearAppDefinitionInProgress((PortletRequest)req);
        return WINDOW_STATE_DETACHED.equalsIgnoreCase(req.getWindowState().toString()) ? JSP_DETACHED : JSP_ICON;
    }

    @ModelAttribute(value="iconSizePixels")
    public String getIconSizePixels(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        return prefs.getValue(PREFERENCE_ICON_SIZE_PIXELS, DEFAULT_ICON_SIZE_PIXELS);
    }

    @ModelAttribute(value="appDefinition")
    public AppDefinition getAppDefinition(PortletRequest req) throws WindowStateException {
        return AppDefinition.fromPortletPreferences((PortletRequest)req);
    }

    @ModelAttribute(value="appUrl")
    public String getAppUrl(PortletRequest req) throws WindowStateException {
        AppDefinition def = this.getAppDefinition(req);
        String configuredUrl = def.getAppUrl();
        String processedUrl = this.expressionProcessor.process(configuredUrl, req);
        return processedUrl;
    }
}

