/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portlet.widget.gadget.model.Module;
import org.jasig.portlet.widget.service.GoogleGadgetService;

public class GoogleGadgetService {
    private static final String GADGET_BASE_URL = "http://www.google.com/ig/directory?synd=open";
    private static final Pattern categoriesPattern = Pattern.compile("<a id=\"[a-zA-z]*\" href=\"/ig/directory\\?synd=open&amp;cat=(.*?)\">(.*?)</a>", 32);
    private static final Pattern gadgetEntryPattern = Pattern.compile("class=\"promoTitle\"><a class=\"\" href=\"/ig/directory\\?synd=open&amp;(?:cat=[a-z]*&amp;)?url=(.*?)\">(.*?)</a>", 32);
    private static final Pattern gadgetImagePattern = Pattern.compile("<img src=\"http://www.gmodules.com/gadgets/proxy\\?refresh=86400&amp;url=(.*?)&amp;container=open&amp;gadget=(.*?)\"", 32);
    private static final Pattern resultCountPattern = Pattern.compile("<span class=\"resultCount\">Results <b>[0-9]* - [0-9]*</b> of <b>([0-9]*?)</b></span>", 32);
    protected final Log log = LogFactory.getLog(this.getClass());

    public List<GadgetCategory> getCategories() {
        ArrayList<GadgetCategory> categories = new ArrayList<GadgetCategory>();
        try {
            String html = this.getStringContentFromUrl(GADGET_BASE_URL);
            Matcher matcher = categoriesPattern.matcher(html);
            while (matcher.find()) {
                String categoryId = matcher.group(1);
                String name = matcher.group(2);
                categories.add(new GadgetCategory(this, categoryId, name));
            }
            Collections.sort(categories);
            return categories;
        }
        catch (ClientProtocolException e) {
            this.log.error((Object)e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
        return null;
    }

    public GadgetList getGadgets(String query, String category, int start) {
        StringBuffer url = new StringBuffer();
        url.append(GADGET_BASE_URL);
        if (StringUtils.isNotBlank((String)query)) {
            url.append("&q=").append(query);
        }
        if (StringUtils.isNotBlank((String)category)) {
            url.append("&cat=").append(category);
        }
        if (start > 0) {
            url.append("&start=").append(start);
        }
        return this.getGadgetsForUrl(url.toString(), gadgetEntryPattern);
    }

    public Module getModule(String url) {
        Module module = null;
        try {
            InputStream stream = this.getStreamFromUrl(url);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Module.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            module = (Module)unmarshaller.unmarshal(stream);
        }
        catch (JAXBException e) {
            this.log.error((Object)e);
        }
        catch (ClientProtocolException e) {
            this.log.error((Object)e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
        return module;
    }

    protected GadgetList getGadgetsForUrl(String url, Pattern entryPattern) {
        try {
            String html = this.getStringContentFromUrl(url);
            ArrayList<GadgetEntry> entries = new ArrayList<GadgetEntry>();
            HashMap<String, String> images = new HashMap<String, String>();
            Matcher imageMatcher = gadgetImagePattern.matcher(html);
            while (imageMatcher.find()) {
                images.put(imageMatcher.group(2), imageMatcher.group(1));
            }
            Matcher entryMatcher = entryPattern.matcher(html);
            while (entryMatcher.find()) {
                String gadgetId = entryMatcher.group(1);
                String name = entryMatcher.group(2);
                String imageUrl = (String)images.get(gadgetId);
                GadgetEntry entry = new GadgetEntry(this, gadgetId, name, imageUrl);
                entries.add(entry);
            }
            int results = 0;
            Matcher resultCountMatcher = resultCountPattern.matcher(html);
            if (resultCountMatcher.find()) {
                results = Integer.parseInt(resultCountMatcher.group(1));
            }
            GadgetList list = new GadgetList(this, results, entries);
            return list;
        }
        catch (ClientProtocolException e) {
            this.log.error((Object)e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringContentFromUrl(String url) throws ClientProtocolException, IOException {
        InputStream input = this.getStreamFromUrl(url);
        String content = null;
        try {
            content = IOUtils.toString((InputStream)input, (String)"UTF-8");
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return content;
    }

    protected InputStream getStreamFromUrl(String url) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        InputStream stream = null;
        if (entity != null) {
            stream = entity.getContent();
        }
        return stream;
    }
}

