/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc.app;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.widget.mvc.app.AppDefinition;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class AppLauncherConfigController {
    private static final String JSP_CONFIG = "app/config";
    private static final String INVALID_FIELDS = "invalidFields";
    private static final String APP_DEFINITION_IN_PROGRESS_PREFIX = "AppLauncherConfigController.APP_DEFINITION_IN_PROGRESS.";
    private final List<AppDefinition.DisplayStrategies> availableDisplayStrategies = Arrays.asList(AppDefinition.DisplayStrategies.IFRAME, AppDefinition.DisplayStrategies.NEW_WINDOW);

    public static void clearAppDefinitionInProgress(PortletRequest req) {
        PortletSession session = req.getPortletSession();
        String key = APP_DEFINITION_IN_PROGRESS_PREFIX + req.getWindowID();
        session.removeAttribute(key);
    }

    @RenderMapping
    public ModelAndView config(PortletRequest req) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        AppDefinition appDefinition = this.getAppDefinition(req);
        model.put("appDefinition", appDefinition);
        String[] invalidSettings = req.getParameterMap().containsKey(INVALID_FIELDS) ? req.getParameterValues(INVALID_FIELDS) : new String[]{};
        model.put(INVALID_FIELDS, Arrays.asList(invalidSettings));
        return new ModelAndView(JSP_CONFIG, model);
    }

    @ActionMapping
    public void saveSettings(ActionRequest req, ActionResponse res) throws PortletModeException {
        AppDefinition appDefinition = AppDefinition.fromFormFields(req);
        List<AppDefinition.Setting> invalidSettings = appDefinition.getInvalidSettings();
        switch (invalidSettings.size()) {
            case 0: {
                AppDefinition.update(req, appDefinition);
                AppLauncherConfigController.clearAppDefinitionInProgress((PortletRequest)req);
                res.setPortletMode(PortletMode.VIEW);
                break;
            }
            default: {
                this.setAppDefinitionInProgress((PortletRequest)req, appDefinition);
                String[] invalidFields = new String[invalidSettings.size()];
                for (int i = 0; i < invalidSettings.size(); ++i) {
                    AppDefinition.Setting p = invalidSettings.get(i);
                    invalidFields[i] = p.getFieldName();
                }
                res.setRenderParameter(INVALID_FIELDS, invalidFields);
            }
        }
    }

    @ModelAttribute(value="availableDisplayStrategies")
    public List<AppDefinition.DisplayStrategies> getAvailableDisplayStrategies() {
        return this.availableDisplayStrategies;
    }

    private AppDefinition getAppDefinition(PortletRequest req) {
        AppDefinition rslt = this.getAppDefinitionInProgress(req);
        if (rslt == null) {
            rslt = AppDefinition.fromPortletPreferences(req);
        }
        if (rslt.isAllDefaults()) {
            rslt = AppDefinition.BLANK_INSTANCE;
        }
        return rslt;
    }

    private AppDefinition getAppDefinitionInProgress(PortletRequest req) {
        AppDefinition rslt = null;
        PortletSession session = req.getPortletSession();
        String key = APP_DEFINITION_IN_PROGRESS_PREFIX + req.getWindowID();
        if (session.getAttributeMap().containsKey(key)) {
            rslt = (AppDefinition)session.getAttribute(key);
        }
        return rslt;
    }

    private void setAppDefinitionInProgress(PortletRequest req, AppDefinition appDefinition) {
        PortletSession session = req.getPortletSession();
        String key = APP_DEFINITION_IN_PROGRESS_PREFIX + req.getWindowID();
        session.setAttribute(key, (Object)appDefinition);
    }
}

