/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;

public class AppDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final AppDefinition BLANK_INSTANCE = new AppDefinition(new HashMap<Setting, String>());
    private final Map<Setting, String> settings;

    public static AppDefinition fromPortletPreferences(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        HashMap<Setting, String> settings = new HashMap<Setting, String>();
        for (Setting p : Setting.values()) {
            String value = prefs.getValue(p.getCode(), p.getDefaultValue());
            settings.put(p, value);
        }
        return new AppDefinition(settings);
    }

    public static AppDefinition fromFormFields(ActionRequest req) {
        HashMap<Setting, String> settings = new HashMap<Setting, String>();
        for (Setting p : Setting.values()) {
            String value = null;
            String fieldName = p.getFieldName();
            String fieldValue = req.getParameter(fieldName);
            if (StringUtils.isNotBlank((String)fieldValue)) {
                value = fieldValue.trim();
            }
            settings.put(p, value);
        }
        return new AppDefinition(settings);
    }

    public static void update(ActionRequest req, AppDefinition appDefinition) {
        List<Setting> invalid = appDefinition.getInvalidSettings();
        if (invalid.size() != 0) {
            throw new RuntimeException("Unable to update;  invalid settings:  " + invalid);
        }
        try {
            PortletPreferences prefs = req.getPreferences();
            for (Setting p : Setting.values()) {
                String value = appDefinition.settings.get((Object)p);
                prefs.setValue(p.getCode(), value);
            }
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save settings:  " + appDefinition.settings);
        }
    }

    public String getAppUrl() {
        return this.settings.get((Object)Setting.APP_URL);
    }

    public String getDisplayStrategy() {
        return this.settings.get((Object)Setting.DISPLAY_STRATEGY);
    }

    public String getIconUrl() {
        return this.settings.get((Object)Setting.ICON_URL);
    }

    public String getLinkTarget() {
        String displayStrategy = this.settings.get((Object)Setting.DISPLAY_STRATEGY);
        if (DisplayStrategies.NEW_WINDOW.getCode().equalsIgnoreCase(displayStrategy)) {
            return "_blank";
        }
        return null;
    }

    public String getLinkTitle() {
        return this.settings.get((Object)Setting.LINK_TITLE);
    }

    public String getTitle() {
        return this.settings.get((Object)Setting.TITLE);
    }

    public String getSubtitle() {
        return this.settings.get((Object)Setting.SUBTITLE);
    }

    public boolean isAllDefaults() {
        boolean rslt = true;
        for (Setting p : Setting.values()) {
            if (StringUtils.equals((String)p.getDefaultValue(), (String)this.settings.get((Object)p))) continue;
            rslt = false;
            break;
        }
        return rslt;
    }

    public List<Setting> getInvalidSettings() {
        ArrayList<Setting> rslt = new ArrayList<Setting>();
        for (Setting p : Setting.values()) {
            String value = this.settings.get((Object)p);
            if (p.validate(value)) continue;
            rslt.add(p);
        }
        return rslt;
    }

    public String toString() {
        return "AppDefinition [settings=" + this.settings + "]";
    }

    private AppDefinition(Map<Setting, String> settings) {
        this.settings = settings;
    }

    public static enum Setting {
        APP_URL("appUrl", "http://www.apereo.org"){

            @Override
            public boolean validate(String value) {
                return value != null && VALID_URL_PATTERN.matcher(value).matches();
            }
        }
        ,
        DISPLAY_STRATEGY("displayStrategy", DisplayStrategies.IFRAME.getCode()){

            @Override
            public boolean validate(String value) {
                boolean rslt = false;
                for (DisplayStrategies s : DisplayStrategies.values()) {
                    if (!s.getCode().equals(value)) continue;
                    rslt = true;
                }
                return rslt;
            }
        }
        ,
        ICON_URL("iconUrl", null){

            @Override
            public boolean validate(String value) {
                return value != null ? VALID_URL_PATTERN.matcher(value).matches() : true;
            }
        }
        ,
        LINK_TITLE("linkTitle", "Launch in a new window"){

            @Override
            public boolean validate(String value) {
                return true;
            }
        }
        ,
        TITLE("title", "Apereo Foundation"){

            @Override
            public boolean validate(String value) {
                return StringUtils.isNotBlank((String)value);
            }
        }
        ,
        SUBTITLE("subtitle", "Serving the academic mission"){

            @Override
            public boolean validate(String value) {
                return true;
            }
        };

        private static final String PREFERENCE_PREFIX = "AppDefinition.";
        private static final String URL_REGEX = "^(https?:)?/.*";
        private static final Pattern VALID_URL_PATTERN;
        private final String fieldName;
        private final String defaultValue;

        private Setting(String fieldName, String defaultValue) {
            this.fieldName = fieldName;
            this.defaultValue = defaultValue;
        }

        public String getCode() {
            return PREFERENCE_PREFIX + this.fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public abstract boolean validate(String var1);

        static {
            VALID_URL_PATTERN = Pattern.compile(URL_REGEX);
        }
    }

    public static enum DisplayStrategies {
        IFRAME("iframe"),
        NEW_WINDOW("newWindow"),
        SAME_WINDOW("sameWindow");

        private final String code;

        private DisplayStrategies(String name) {
            this.code = name;
        }

        public String getCode() {
            return this.code;
        }
    }
}

