/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class SimpleJspPortletController {
    public static final String JSP_NAME_PREFERENCE = "SimpleJspPortletController.jspName";
    public static final String PREF_SECURITY_ROLE_NAMES = "SimpleJspPortletController.securityRolesToTest";
    public static final String INSTRUCTIONS_VIEW = "simple-jsp-instructions";
    private final Log log = LogFactory.getLog(this.getClass());
    private Properties properties;

    @Required
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @RenderMapping
    public String doView(RenderRequest req, Model model) {
        this.addSecurityRoleChecksToModel((PortletRequest)req, model);
        model.addAttribute("property", (Object)this.properties);
        PortletPreferences prefs = req.getPreferences();
        ArrayList<String> allowableJspPages = new ArrayList<String>();
        String[] jspNamesAnyStateAnyMode = prefs.getValues(JSP_NAME_PREFERENCE, new String[]{INSTRUCTIONS_VIEW});
        allowableJspPages.addAll(Arrays.asList(jspNamesAnyStateAnyMode));
        String[] jspNamesThisWindowState = prefs.getValues("SimpleJspPortletController.jspName." + req.getWindowState().toString().toUpperCase(), new String[0]);
        allowableJspPages.addAll(Arrays.asList(jspNamesThisWindowState));
        String rslt = (String)allowableJspPages.get(0);
        String jspNameParam = req.getParameter("nextJspPage");
        if (jspNameParam != null) {
            if (allowableJspPages.contains(jspNameParam)) {
                rslt = jspNameParam;
            } else {
                this.log.warn((Object)("User '" + req.getRemoteUser() + "' requested a JSP not in the whitelist:  " + jspNameParam));
            }
        }
        return rslt;
    }

    @ActionMapping
    public void sendRedirect(@RequestParam(value="redirect") String redirect, ActionRequest req, ActionResponse res) throws IOException {
        if (StringUtils.isBlank((String)redirect)) {
            String msg = "Parameter 'redirect' cannot be blank";
            throw new IllegalArgumentException(msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirecting user '" + req.getRemoteUser() + "' to the following URL:  " + redirect));
        }
        res.sendRedirect(redirect);
    }

    @ModelAttribute(value="userInfo")
    public Map<String, String> addUserInfoToModel(PortletRequest req) {
        Map rslt = (Map)req.getAttribute("javax.portlet.userinfo");
        return rslt;
    }

    private void addSecurityRoleChecksToModel(PortletRequest req, Model model) {
        PortletPreferences prefs = req.getPreferences();
        String[] securityRoles = prefs.getValues(PREF_SECURITY_ROLE_NAMES, new String[0]);
        for (int i = 0; i < securityRoles.length; ++i) {
            model.addAttribute("is" + securityRoles[i], (Object)req.isUserInRole(securityRoles[i]));
        }
    }
}

