/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service;

import java.io.Serializable;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.jasig.portlet.widget.dao.PluggableDataDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CachingConfigurableDataServiceImpl
implements PluggableDataDao {
    public static final String PREF_DATASOURCE_BEAN_NAME = "PluggableDataPortlet.Service.datasourceBeanName";
    public static final String PREF_CACHE_NAME = "PluggableDataPortlet.Service.cacheName";
    public static final String PREF_CACHE_PER_USER = "PluggableDataPortlet.Service.datasourcePerUserCache";
    public static final String DEFAULT_CACHE_NAME = "pluggableDataCache";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ApplicationContext applicationContext;

    public List<? extends Object> getData(PortletRequest req) {
        String cacheKey;
        String daoBean = req.getPreferences().getValue(PREF_DATASOURCE_BEAN_NAME, "");
        Cache cache = this.getCache(req);
        Element cachedElement = cache.get((Serializable)((Object)(cacheKey = this.createCacheKey(req, daoBean))));
        if (cachedElement == null) {
            this.log.debug("Item not found in cache. Invoking dao bean {}", (Object)daoBean);
            PluggableDataDao dao = (PluggableDataDao)this.applicationContext.getBean(daoBean);
            if (dao == null) {
                throw new RuntimeException("Name of spring bean implementing PluggableData must be specified in portlet preference PluggableDataPortlet.Service.datasourceBeanName");
            }
            List result = dao.getData(req);
            cachedElement = new Element((Object)cacheKey, (Object)result);
            cache.put(cachedElement);
        } else {
            this.log.debug("Cache hit; returning item from cache for user {}", (Object)req.getRemoteUser());
        }
        return (List)((Object)cachedElement.getValue());
    }

    private Cache getCache(PortletRequest req) {
        String cacheName = req.getPreferences().getValue(PREF_CACHE_NAME, DEFAULT_CACHE_NAME);
        this.log.debug("Looking up cache '{}'", (Object)cacheName);
        Cache cache = CacheManager.getInstance().getCache(cacheName);
        if (cache == null) {
            throw new RuntimeException("Unable to find cache named " + cacheName + ". Check portlet preference value " + PREF_CACHE_NAME + " and configuration in ehcache.xml");
        }
        return cache;
    }

    private String createCacheKey(PortletRequest req, String beanName) {
        PortletPreferences prefs = req.getPreferences();
        boolean perUser = Boolean.valueOf(prefs.getValue(PREF_CACHE_PER_USER, "true"));
        String key = (perUser ? req.getRemoteUser() + "-" : "") + beanName + "-pluggableDataService";
        this.log.debug("Using cache key {}", (Object)key);
        return key;
    }
}

