/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.service.DefaultPropertyAccessor;
import org.jasig.portlet.widget.service.IExpressionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class SpringELProcessor
implements IExpressionProcessor,
BeanFactoryAware {
    private static ParserContext PARSER_CONTEXT = new TemplateParserContext("${", "}");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private BeanResolver beanResolver;
    private Properties properties;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    @Required
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String process(String value, PortletRequest request) {
        Map<String, Object> context = this.getContext(request);
        StandardEvaluationContext sec = new StandardEvaluationContext(context);
        sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new DefaultPropertyAccessor(PARSER_CONTEXT.getExpressionPrefix(), PARSER_CONTEXT.getExpressionSuffix()));
        sec.setBeanResolver(this.beanResolver);
        SpelExpressionParser parser = new SpelExpressionParser();
        String processed = (String)parser.parseExpression(value, PARSER_CONTEXT).getValue((EvaluationContext)sec, String.class);
        return processed;
    }

    private Map<String, Object> getContext(PortletRequest request) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (String key : this.properties.stringPropertyNames()) {
            context.put(key, this.properties.getProperty(key));
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            requestMap.put(name, request.getParameter(name));
        }
        context.put("request", requestMap);
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        context.put("user", userInfo);
        return context;
    }
}

