/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.spel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.service.DefaultPropertyAccessor;
import org.jasig.portlet.widget.service.IExpressionProcessor;
import org.jasig.portlet.widget.service.PropertyResolverAccessor;
import org.jasig.portlet.widget.service.spel.IContextElementsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.env.PropertyResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;

@Service
public class SpELExpressionProcessor
implements IExpressionProcessor {
    private static ParserContext PARSER_CONTEXT = new TemplateParserContext("${", "}");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    private PropertyResolver propertyResolver;
    private BeanResolver beanResolver;
    private final Set<IContextElementsProvider> contextElementsProviders = new HashSet();

    @Autowired
    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    @PostConstruct
    public void init() {
        this.beanResolver = new BeanFactoryResolver((BeanFactory)this.applicationContext);
        this.contextElementsProviders.addAll(this.applicationContext.getBeansOfType(IContextElementsProvider.class).values());
    }

    public String process(String value, PortletRequest request) {
        HashMap context = new HashMap();
        for (IContextElementsProvider cep : this.contextElementsProviders) {
            context.putAll(cep.provideElements(request));
        }
        StandardEvaluationContext sec = new StandardEvaluationContext(context);
        sec.setVariable("systemProperties", (Object)this.propertyResolver);
        sec.addPropertyAccessor((PropertyAccessor)new PropertyResolverAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new ReflectivePropertyAccessor());
        sec.addPropertyAccessor((PropertyAccessor)new DefaultPropertyAccessor(PARSER_CONTEXT.getExpressionPrefix(), PARSER_CONTEXT.getExpressionSuffix()));
        sec.setBeanResolver(this.beanResolver);
        SpelExpressionParser parser = new SpelExpressionParser();
        String processed = (String)parser.parseExpression(value, PARSER_CONTEXT).getValue((EvaluationContext)sec, String.class);
        return processed;
    }
}

