/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

@Deprecated
public class ExtendedPropertySourcesPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    public static final String EXTENDED_PROPERTIES_SOURCE = "extendedPropertiesSource";
    public static final String JAYSYPT_ENCRYPTION_KEY_VARIABLE = "UP_JASYPT_KEY";
    private PropertyResolver propertyResolver;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ExtendedPropertySourcesPlaceholderConfigurer() {
        super.setIgnoreResourceNotFound(true);
    }

    public void setIgnoreResourceNotFound(boolean value) {
        if (!value) {
            String msg = "Instances of PortalPropertySourcesPlaceholderConfigurer are always ignoreResourceNotFound=true";
            throw new UnsupportedOperationException("Instances of PortalPropertySourcesPlaceholderConfigurer are always ignoreResourceNotFound=true");
        }
    }

    public void setLocations(Resource[] locations) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource r : locations) {
            if (r.exists()) {
                list.add(r);
                continue;
            }
            this.logger.debug("The following Resource was not present (it may be optional, or it's absence may lead to issues):  ", (Object)r);
        }
        super.setLocations(list.toArray(new Resource[0]));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyResolver == null) {
            try {
                MutablePropertySources sources = new MutablePropertySources();
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource(EXTENDED_PROPERTIES_SOURCE, this.mergeProperties());
                sources.addLast((PropertySource)localPropertySource);
                this.propertyResolver = new PropertySourcesPropertyResolver((PropertySources)sources);
            }
            catch (IOException e) {
                throw new BeanInitializationException("Could not load properties", (Throwable)e);
            }
        }
        super.postProcessBeanFactory(beanFactory);
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    protected Properties mergeProperties() throws IOException {
        EncryptableProperties rslt = null;
        String encryptionKey = System.getenv(JAYSYPT_ENCRYPTION_KEY_VARIABLE);
        if (encryptionKey != null) {
            this.logger.info("Jasypt support for encrypted property values ENABLED");
            StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
            encryptor.setPassword(encryptionKey);
            rslt = new EncryptableProperties((StringEncryptor)encryptor);
            if (this.localOverride) {
                this.loadProperties((Properties)rslt);
            }
            if (this.localProperties != null) {
                for (int i = 0; i < this.localProperties.length; ++i) {
                    CollectionUtils.mergePropertiesIntoMap((Properties)this.localProperties[i], (Map)rslt);
                }
            }
            if (!this.localOverride) {
                this.loadProperties((Properties)rslt);
            }
        } else {
            this.logger.info("Jasypt support for encrypted property values DISABLED;  specify environment variable {} to use this feature", (Object)JAYSYPT_ENCRYPTION_KEY_VARIABLE);
            return super.mergeProperties();
        }
        return rslt;
    }
}

