/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service;

import com.googlecode.ehcache.annotations.Cacheable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class YouTubeService {
    protected final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Cacheable(cacheName="youTubeCache")
    public String getYouTubeResponse(String userName) {
        String url = "http://gdata.youtube.com/feeds/api/videos?author=" + userName + "&v=2&alt=jsonc&orderby=published";
        HttpClient client = new HttpClient();
        GetMethod get = null;
        try {
            int rc;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving proxy url " + url));
            }
            if ((rc = client.executeMethod((HttpMethod)(get = new GetMethod(url)))) == 200) {
                String response;
                this.log.debug((Object)"request completed successfully");
                InputStream in = get.getResponseBodyAsStream();
                String string = response = IOUtils.toString((InputStream)in);
                return string;
            }
            this.log.warn((Object)("HttpStatus for " + url + ":" + rc));
        }
        catch (HttpException e) {
            this.log.warn((Object)"Error proxying url", (Throwable)e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error proxying url", (Throwable)e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }
}

