/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc.app;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.WindowStateException;
import org.jasig.portlet.widget.mvc.app.AppDefinition;
import org.jasig.portlet.widget.service.IExpressionProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AppLauncherRedirectController {
    public static final String ACTION_PARAMETER_NAME = "action";
    public static final String REDIRECT_ACTION = "redirect";
    private IExpressionProcessor expressionProcessor;

    @Autowired
    public void setExpressionProcessor(IExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    @ActionMapping(params={"action=redirect"})
    public void redirectToApp(ActionRequest req, ActionResponse res) {
        try {
            AppDefinition def = this.getAppDefinition((PortletRequest)req);
            String configuredUrl = def.getAppUrl();
            String redirectUrl = this.expressionProcessor.process(configuredUrl, (PortletRequest)req);
            res.sendRedirect(redirectUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate or invoke redirectUrl", e);
        }
    }

    @ModelAttribute(value="appDefinition")
    public AppDefinition getAppDefinition(PortletRequest req) throws WindowStateException {
        return AppDefinition.fromPortletPreferences(req);
    }
}

