/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portlet.widget.service.spel;

import java.util.HashMap;
import java.util.Map;

import javax.portlet.PortletRequest;

import org.springframework.stereotype.Component;

/**
 * Provides the USER_INFO map from the Portlet API as a SpEL context element.
 *
 * @author drewwills
 */
@Component
public class UserInfoContextElementsProvider implements IContextElementsProvider {

    private static final String CONTEXT_KEY = "user";

    @Override
    public Map<String, Object> provideElements(PortletRequest req) {
        @SuppressWarnings("unchecked")
        final Map<String,String> userInfo = (Map<String,String>) req.getAttribute(PortletRequest.USER_INFO);
        final Map<String,Object> rslt = new HashMap<>();
        rslt.put(CONTEXT_KEY, userInfo);
        return rslt;
    }

}
