/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.dom4j.Document;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PortletXmlGroupService {
    private static final Logger log = LoggerFactory.getLogger(PortletXmlGroupService.class);
    private static final String PORTLET_XML_PATH = "/WEB-INF/portlet.xml";
    private Document doc;
    private NamespaceContext namespaceContext;
    private XPath xpathRoleName;
    @Autowired
    private ServletContext servletContext;

    @PostConstruct
    public void init() {
        try {
            URL portletXmlUrl = this.servletContext.getResource(PORTLET_XML_PATH);
            SAXReader reader = new SAXReader();
            this.doc = reader.read(portletXmlUrl);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("p", "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd");
            this.namespaceContext = new SimpleNamespaceContext(namespaces);
            this.xpathRoleName = this.doc.createXPath("p:role-name");
            this.xpathRoleName.setNamespaceContext(this.namespaceContext);
        }
        catch (Exception e) {
            log.error("Cannot load {}", (Object)PORTLET_XML_PATH, (Object)e);
        }
    }

    Set<String> getGroups(String portletName) {
        if (this.doc == null) {
            return null;
        }
        String xpathStr = "//p:portlet[p:portlet-name='" + portletName + "']/p:security-role-ref";
        XPath xpath = this.doc.createXPath(xpathStr);
        xpath.setNamespaceContext(this.namespaceContext);
        List roles = xpath.selectNodes((Object)this.doc);
        if (roles == null || roles.isEmpty()) {
            log.error("No security roles found for portlet: {}", (Object)portletName);
            return Collections.emptySet();
        }
        Set<String> groups = roles.stream().map(e -> this.xpathRoleName.selectSingleNode(e).getText()).collect(Collectors.toSet());
        return groups;
    }
}

