/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.widget.links.ResourceLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceLinkService {
    private static final Logger log = LoggerFactory.getLogger(ResourceLinkService.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String linkToJson(ResourceLink link) {
        String json = null;
        if (link != null) {
            try {
                json = mapper.writeValueAsString((Object)link);
            }
            catch (JsonProcessingException e) {
                log.error("Unable to parse link to JSON: %s", (Object)link.toString(), (Object)e);
            }
        }
        return json;
    }

    public static ResourceLink jsonToLink(String json) {
        ResourceLink link = null;
        try {
            link = (ResourceLink)mapper.readValue(json, ResourceLink.class);
        }
        catch (IOException e) {
            log.error("Unable to parse JSON to ResourceLink: " + json, (Throwable)e);
        }
        return link;
    }

    public static List<ResourceLink> jsonArrayToLinkList(String json) {
        List links = null;
        if (json != null) {
            try {
                links = (List)mapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                log.error("Unable to parse JSON to ResourceLink: " + json, (Throwable)e);
            }
        }
        return links;
    }

    public static String[] linkListToJsonStrArray(List<ResourceLink> links) {
        return (String[])links.stream().map(e -> ResourceLinkService.linkToJson((ResourceLink)e)).toArray(String[]::new);
    }

    public static List<ResourceLink> createResourceLinkList(String[] jsonStrs) {
        if (jsonStrs == null) {
            return null;
        }
        List<ResourceLink> links = Arrays.asList(jsonStrs).stream().map(e -> ResourceLinkService.jsonToLink((String)e)).filter(Objects::nonNull).collect(Collectors.toList());
        if (jsonStrs.length != links.size()) {
            log.warn("jsonStr.length (%d) != linksByTitle.size (%d)", (Object)jsonStrs.length, (Object)links.size());
        }
        return links;
    }

    public static String convertStringArrayToJsonArray(String[] jsonStrs) {
        if (jsonStrs == null) {
            return "[]";
        }
        return "[" + StringUtils.join((Object[])jsonStrs, (char)',') + "]";
    }
}

