/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.links.ResourceLink;
import org.jasig.portlet.widget.links.ResourceLinksBaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ResourceLinksController
extends ResourceLinksBaseController {
    private static final Logger log = LoggerFactory.getLogger(ResourceLinksController.class);

    @RenderMapping
    public String view(PortletRequest req) throws Exception {
        Set groups = this.getGroups();
        return "links/links";
    }

    @ModelAttribute(value="links")
    public List<ResourceLink> getResourceLinks(PortletRequest req) {
        ArrayList<ResourceLink> filteredLinks = new ArrayList<ResourceLink>();
        List allLinks = super.getResourceLinks(req);
        for (ResourceLink link : allLinks) {
            if (link.getGroups().isEmpty()) {
                filteredLinks.add(link);
                continue;
            }
            boolean inGroup = link.getGroups().stream().anyMatch(arg_0 -> ((PortletRequest)req).isUserInRole(arg_0));
            if (!inGroup) continue;
            filteredLinks.add(link);
        }
        return filteredLinks;
    }

    @ModelAttribute(value="iconSizePixels")
    public String getIconSizePixels(PortletRequest req) {
        return super.getIconSizePixels(req);
    }
}

