/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.service.spel;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.service.spel.IContextElementsProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class AppLauncherPropertiesContextElementsProvider
implements IContextElementsProvider {
    @Value(value="classpath:app-launcher.properties")
    private Resource propertiesResource;
    private final Properties properties = new Properties();

    @PostConstruct
    public void init() {
        try (InputStream inpt = this.propertiesResource.getInputStream();){
            this.properties.load(inpt);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load app-launcher.properties from the classpath", e);
        }
    }

    public Map<String, Object> provideElements(PortletRequest req) {
        HashMap<String, Object> rslt = new HashMap<String, Object>();
        for (String key : this.properties.stringPropertyNames()) {
            rslt.put(key, this.properties.getProperty(key));
        }
        return rslt;
    }
}

