/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import java.util.List;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.widget.links.PortletXmlGroupService;
import org.jasig.portlet.widget.links.ResourceLink;
import org.jasig.portlet.widget.links.ResourceLinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.portlet.context.PortletConfigAware;

public class ResourceLinksBaseController
implements PortletConfigAware {
    private static final Logger log = LoggerFactory.getLogger(ResourceLinksBaseController.class);
    protected static final String PREF_LINK_ATTR = "resource-link";
    protected static final String PREF_ICON_SIZE_PIXELS = "icon-size";
    protected static final String DEFAULT_ICON_SIZE_PIXELS = "200";
    protected PortletConfig portletConfig;
    @Autowired
    protected PortletXmlGroupService groupService;

    public List<ResourceLink> getResourceLinks(PortletRequest req) {
        PortletPreferences preferences = req.getPreferences();
        String[] prefLinks = preferences.getValues(PREF_LINK_ATTR, null);
        return ResourceLinkService.createResourceLinkList(prefLinks);
    }

    public String getResourceLinksJson(PortletRequest req) {
        PortletPreferences preferences = req.getPreferences();
        String[] prefLinks = preferences.getValues(PREF_LINK_ATTR, null);
        return ResourceLinkService.convertStringArrayToJsonArray(prefLinks);
    }

    public String getIconSizePixels(PortletRequest req) {
        PortletPreferences preferences = req.getPreferences();
        return preferences.getValue(PREF_ICON_SIZE_PIXELS, DEFAULT_ICON_SIZE_PIXELS);
    }

    protected Set<String> getGroups() {
        String portletName = this.portletConfig.getPortletName();
        return this.groupService.getGroups(portletName);
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

