/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.mvc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.widget.dao.PluggableDataDao;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PluggableDataJspPortletController {
    public static final String PREF_JSP_NAME = "PluggableDataJspPortlet.Controller.jspName";
    public static final String PREF_EXPOSE_DATA_AS_JSON = "PluggableDataJspPortlet.Controller.asJson";
    public static final String PREF_SECURITY_ROLE_NAMES = "PluggableDataJspPortlet.Controller.securityRolesToTest";
    public static final String INSTRUCTIONS_VIEW = "pluggableData-jsp-instructions";
    PluggableDataDao service;
    private final Log log = LogFactory.getLog(this.getClass());

    @RenderMapping
    public String doView(RenderRequest req, Model model) {
        String jspName;
        this.addSecurityRoleChecksToModel((PortletRequest)req, model);
        List<? extends Object> data = this.service.getData((PortletRequest)req);
        model.addAttribute("data", data);
        boolean asJson = Boolean.valueOf(req.getPreferences().getValue(PREF_EXPOSE_DATA_AS_JSON, "false"));
        if (asJson) {
            JSON jsonData = JSONSerializer.toJSON(data);
            model.addAttribute("jsonData", (Object)jsonData.toString(4));
        }
        if ((jspName = req.getParameter("nextJspPage")) == null) {
            PortletPreferences prefs = req.getPreferences();
            jspName = prefs.getValue(PREF_JSP_NAME, INSTRUCTIONS_VIEW);
        }
        return jspName;
    }

    @ActionMapping
    public void sendRedirect(@RequestParam(value="redirect") String redirect, ActionRequest req, ActionResponse res) throws IOException {
        if (StringUtils.isBlank((String)redirect)) {
            String msg = "Parameter 'redirect' cannot be blank";
            throw new IllegalArgumentException(msg);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirecting user '" + req.getRemoteUser() + "' to the following URL:  " + redirect));
        }
        res.sendRedirect(redirect);
    }

    @ResourceMapping
    public String getData(ResourceRequest req, ResourceResponse resp, Model model) {
        this.addSecurityRoleChecksToModel((PortletRequest)req, model);
        List<? extends Object> data = this.service.getData((PortletRequest)req);
        model.addAttribute("data", data);
        return "jsonView";
    }

    @ModelAttribute(value="userInfo")
    public Map<String, String> addUserInfoToModel(PortletRequest req) {
        Map rslt = (Map)req.getAttribute("javax.portlet.userinfo");
        return rslt;
    }

    private void addSecurityRoleChecksToModel(PortletRequest req, Model model) {
        PortletPreferences prefs = req.getPreferences();
        String[] securityRoles = prefs.getValues(PREF_SECURITY_ROLE_NAMES, new String[0]);
        for (int i = 0; i < securityRoles.length; ++i) {
            model.addAttribute("is" + securityRoles[i].replace(" ", "_"), (Object)req.isUserInRole(securityRoles[i]));
        }
    }

    @Required
    public void setService(PluggableDataDao service) {
        this.service = service;
    }
}

