/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class ResourceLink {
    @NonNull
    private String title = "Title";
    private String description = "Short description";
    private String icon = "fa-link";
    @NonNull
    private String url = "/";
    private final List<String> groups = new ArrayList();

    @JsonIgnore
    public boolean isIconFontAwesome() {
        return this.icon.startsWith("fa-");
    }

    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setGroups(List<String> groups) {
        assert (groups != null);
        this.groups.clear();
        this.groups.addAll(groups);
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceLink)) {
            return false;
        }
        ResourceLink other = (ResourceLink)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List this$groups = this.getGroups();
        List other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "ResourceLink(title=" + this.getTitle() + ", description=" + this.getDescription() + ", icon=" + this.getIcon() + ", url=" + this.getUrl() + ", groups=" + this.getGroups() + ")";
    }
}

