/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.widget.links;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.widget.links.ResourceLinkService;
import org.jasig.portlet.widget.links.ResourceLinksBaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class ResourceLinksConfigController
extends ResourceLinksBaseController {
    private static final Logger log = LoggerFactory.getLogger(ResourceLinksConfigController.class);

    @RenderMapping
    public String config(PortletRequest req) throws Exception {
        return "links/configLinks";
    }

    @ActionMapping
    public void saveResourceLinks(ActionRequest req, ActionResponse res, @RequestParam(value="save", required=false) String save, @RequestParam(value="links", required=false) String linksJson) throws PortletException, IOException {
        if (StringUtils.isNotBlank((String)save)) {
            log.debug(linksJson);
            List links = ResourceLinkService.jsonArrayToLinkList((String)linksJson);
            if (links == null || links.isEmpty()) {
                return;
            }
            String[] validLinksJson = ResourceLinkService.linkListToJsonStrArray((List)links);
            req.getPreferences().setValues("resource-link", validLinksJson);
            req.getPreferences().store();
        }
        res.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="linksJson")
    public String getResourceLinksJsonArray(PortletRequest req) {
        return super.getResourceLinksJson(req);
    }

    @ModelAttribute(value="groups")
    public Set<String> getGroups() {
        return super.getGroups();
    }

    @ModelAttribute(value="iconSizePixels")
    public String getIconSizePixels(PortletRequest req) {
        return super.getIconSizePixels(req);
    }
}

