/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.mvc.portlet;

import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class MapViewController {
    public static final String PREFERENCE_API_KEY = "apiKey";
    public static final String PREFERENCE_STARTING_LATITUDE = "latitude";
    public static final String PREFERENCE_STARTING_LONGITUDE = "longitude";
    public static final String PREFERENCE_STARTING_ZOOM = "zoom";
    public static final String MAP_OPTION_MAPTYPE_CONTROL = "mapTypeControl";
    public static final String MAP_OPTIONS_PAN_CONTROL = "panControl";
    public static final String MAP_OPTIONS_ZOOM_CONTROL = "zoomControl";
    public static final String MAP_OPTIONS_STREET_VIEW = "streetView";
    public static final String MAP_OPTIONS_SCALE_CONTROL = "scaleControl";
    public static final String MAP_OPTIONS_ROTATE_CONTROL = "rotateControl";
    public static final String MAP_OPTIONS_OVERVIEW_CONTROL = "overviewControl";

    @RequestMapping
    public ModelAndView getView(RenderRequest request) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PortletPreferences preferences = request.getPreferences();
        String apiKey = preferences.getValue(PREFERENCE_API_KEY, "ABQIAAAA6IxXqpYkVvIBECmLUV99fRTwM0brOpm-All5BF6PoaKBxRWWERT7EOEqD89hlpB20tCIxwLUa9Y9rw");
        map.put(PREFERENCE_API_KEY, apiKey);
        double startingLatitude = Double.parseDouble(preferences.getValue(PREFERENCE_STARTING_LATITUDE, "41.300937"));
        map.put(PREFERENCE_STARTING_LATITUDE, startingLatitude);
        double startingLongitude = Double.parseDouble(preferences.getValue(PREFERENCE_STARTING_LONGITUDE, "-72.932103"));
        map.put(PREFERENCE_STARTING_LONGITUDE, startingLongitude);
        int startingZoom = Integer.parseInt(preferences.getValue(PREFERENCE_STARTING_ZOOM, "18"));
        map.put(PREFERENCE_STARTING_ZOOM, startingZoom);
        boolean mapTypeControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTION_MAPTYPE_CONTROL, "true"));
        map.put(MAP_OPTION_MAPTYPE_CONTROL, mapTypeControlBool);
        boolean panControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_PAN_CONTROL, "false"));
        map.put(MAP_OPTIONS_PAN_CONTROL, panControlBool);
        boolean zoomControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_ZOOM_CONTROL, "true"));
        map.put(MAP_OPTIONS_ZOOM_CONTROL, zoomControlBool);
        boolean streetViewBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_STREET_VIEW, "true"));
        map.put(MAP_OPTIONS_STREET_VIEW, streetViewBool);
        boolean scaleControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_SCALE_CONTROL, "true"));
        map.put(MAP_OPTIONS_SCALE_CONTROL, scaleControlBool);
        boolean rotateControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_ROTATE_CONTROL, "false"));
        map.put(MAP_OPTIONS_ROTATE_CONTROL, rotateControlBool);
        boolean overviewControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_OVERVIEW_CONTROL, "false"));
        map.put(MAP_OPTIONS_OVERVIEW_CONTROL, overviewControlBool);
        map.put("isHttps", request.isSecure());
        map.put("isMobile", "UniversalityMobile".equals(request.getProperty("themeName")));
        return new ModelAndView("mapView", map);
    }
}

