/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.dao;

import java.util.Collection;
import java.util.Collections;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.maps.dao.IMapDao;
import org.jasig.portlet.maps.model.xml.Location;
import org.jasig.portlet.maps.model.xml.MapData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class DefaultMapDaoImpl
implements IMapDao {
    protected Log log = LogFactory.getLog(this.getClass());
    private RestTemplate restTemplate;

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public MapData getMap(PortletRequest request) {
        String urlTemplate = this.getUrlTemplate(request);
        MapData map = (MapData)this.restTemplate.getForObject(urlTemplate, MapData.class, Collections.emptyMap());
        this.postProcessData(map);
        return map;
    }

    protected String getUrlTemplate(PortletRequest request) {
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(request.getScheme()).append("://");
        urlBuffer.append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            urlBuffer.append(":").append(port);
        }
        urlBuffer.append(request.getContextPath());
        urlBuffer.append("/data/map.json");
        return urlBuffer.toString();
    }

    protected void postProcessData(MapData map) {
        for (Location location : map.getLocations()) {
            StringBuffer searchString = new StringBuffer();
            searchString.append(location.getName().toLowerCase());
            searchString.append("~");
            searchString.append(location.getAbbreviation().toLowerCase());
            searchString.append("~");
            searchString.append(StringUtils.join((Collection)location.getSearchKeys(), (String)"~"));
            location.setSearchText(searchString.toString());
        }
    }
}

