/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jasig.portlet.maps.model.xml.Location;
import org.jasig.portlet.maps.model.xml.MapData;
import org.jasig.portlet.maps.tools.ByNameLocationComparator;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapDataTransformer {
    private static ObjectMapper mapper = new ObjectMapper();
    private static RestTemplate restTemplate = new RestTemplate();
    private static String geocodingUrl = "http://maps.googleapis.com/maps/api/geocode/json?latlng={lat},{lng}&sensor=false";

    public static void main(String[] args) {
        MapData data = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MapData.class});
            Unmarshaller u = jc.createUnmarshaller();
            data = (MapData)u.unmarshal((InputStream)new FileInputStream(new File("map-data-transformed.xml")));
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
            return;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        MapDataTransformer.setAbbreviations((MapData)data);
        Collections.sort(data.getLocations(), new ByNameLocationComparator());
        try {
            mapper.defaultPrettyPrintingWriter().writeValue(new File("map.json"), (Object)data);
        }
        catch (JsonGenerationException e) {
            System.out.println("Error generating JSON data for map");
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            System.out.println("Error generating JSON data for map");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error writing JSON data to map file");
            e.printStackTrace();
        }
    }

    protected static void setAbbreviations(MapData data) {
        HashSet<String> usedIds = new HashSet<String>();
        for (Location location : data.getLocations()) {
            if (StringUtils.isNotBlank((String)location.getAbbreviation()) && !usedIds.contains(location.getAbbreviation())) {
                usedIds.add(location.getAbbreviation());
                continue;
            }
            String defaultId = location.getName().replaceAll("[^a-zA-Z0-9]", "");
            if (!usedIds.contains(defaultId)) {
                location.setAbbreviation(defaultId);
                usedIds.add(defaultId);
                continue;
            }
            int idx = 1;
            String id = defaultId.concat(String.valueOf(idx));
            while (usedIds.contains(id)) {
                id = defaultId.concat(String.valueOf(++idx));
            }
            location.setAbbreviation(id);
            usedIds.add(id);
        }
    }

    protected static void setAddresses(MapData data) {
        for (Location location : data.getLocations()) {
            String address;
            if (!StringUtils.isBlank((String)location.getAddress())) continue;
            HashMap<String, BigDecimal> coordinates = new HashMap<String, BigDecimal>();
            coordinates.put("lat", location.getLatitude());
            coordinates.put("lng", location.getLongitude());
            Map response = (Map)restTemplate.getForObject(geocodingUrl, Map.class, coordinates);
            System.out.println(response);
            List results = (List)response.get("results");
            if (results.size() <= 0 || (address = (String)((Map)results.get(0)).get("formatted_address")) == null) continue;
            location.setAddress(address);
        }
    }

    static {
        restTemplate.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
    }
}

