/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.mvc.portlet;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.maps.dao.IMapDao;
import org.jasig.portlet.maps.model.xml.DefaultLocation;
import org.jasig.portlet.maps.model.xml.MapData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class MapViewController {
    public static final String PREFERENCE_API_KEY = "apiKey";
    public static final String PREFERENCE_USE_PORTAL_JS_LIBS = "usePortalJsLibs";
    public static final String PREFERENCE_PORTAL_JS_NAMESPACE = "portalJsNamespace";
    public static final String PREFERENCE_STARTING_LATITUDE = "latitude";
    public static final String PREFERENCE_STARTING_LONGITUDE = "longitude";
    public static final String PREFERENCE_STARTING_ZOOM = "zoom";
    public static final String PREFERENCE_MAP_DATA_URL = "mapDataUrl";
    public static final String MAP_OPTION_MAPTYPE_CONTROL = "mapTypeControl";
    public static final String MAP_OPTIONS_PAN_CONTROL = "panControl";
    public static final String MAP_OPTIONS_ZOOM_CONTROL = "zoomControl";
    public static final String MAP_OPTIONS_STREET_VIEW = "streetView";
    public static final String MAP_OPTIONS_SCALE_CONTROL = "scaleControl";
    public static final String MAP_OPTIONS_ROTATE_CONTROL = "rotateControl";
    public static final String MAP_OPTIONS_OVERVIEW_CONTROL = "overviewControl";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IMapDao dao;
    private String mapDataUrl;
    private String portalProtocol;
    private String defaultLatitude;
    private String defaultLongitude;
    private String defaultZoom;

    @Autowired(required=true)
    public void setMapDao(IMapDao dao) {
        this.dao = dao;
    }

    @Value(value="${map.defaultdao.url:http://localhost:8080/MapPortlet/data/map.json}")
    public void setMapDataUrl(String mapDataUrl) {
        this.mapDataUrl = mapDataUrl;
    }

    @Value(value="${portal.protocol:http}")
    public void setPortalProtocol(String portalProtocol) {
        this.portalProtocol = portalProtocol;
    }

    @Value(value="${map.default.latitude:41.300937}")
    public void setDefaultLatitude(String defaultLatitude) {
        this.defaultLatitude = defaultLatitude;
    }

    @Value(value="${map.default.longitude:-72.932103}")
    public void setDefaultLongitude(String defaultLongitude) {
        this.defaultLongitude = defaultLongitude;
    }

    @Value(value="${map.default.zoom:17}")
    public void setDefaultZoom(String defaultZoom) {
        this.defaultZoom = defaultZoom;
    }

    @RequestMapping
    public ModelAndView getView(RenderRequest request, @RequestParam(required=false) String location) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.log.debug((Object)"Getting map data during render request");
        MapData mapData = this.getMapData((PortletRequest)request);
        PortletPreferences preferences = request.getPreferences();
        String apiKey = preferences.getValue(PREFERENCE_API_KEY, null);
        map.put(PREFERENCE_API_KEY, apiKey);
        DefaultLocation defaultLocation = mapData.getDefaultLocation();
        Double startingLatitude = this.getLatOrLong(preferences, defaultLocation != null ? defaultLocation.getLatitude() : null, PREFERENCE_STARTING_LATITUDE, this.defaultLatitude);
        map.put(PREFERENCE_STARTING_LATITUDE, startingLatitude);
        Double startingLongitude = this.getLatOrLong(preferences, defaultLocation != null ? defaultLocation.getLongitude() : null, PREFERENCE_STARTING_LONGITUDE, this.defaultLongitude);
        map.put(PREFERENCE_STARTING_LONGITUDE, startingLongitude);
        int startingZoom = Integer.parseInt(preferences.getValue(PREFERENCE_STARTING_ZOOM, this.defaultZoom));
        map.put(PREFERENCE_STARTING_ZOOM, startingZoom);
        boolean mapTypeControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTION_MAPTYPE_CONTROL, "true"));
        map.put(MAP_OPTION_MAPTYPE_CONTROL, mapTypeControlBool);
        boolean panControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_PAN_CONTROL, "false"));
        map.put(MAP_OPTIONS_PAN_CONTROL, panControlBool);
        boolean zoomControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_ZOOM_CONTROL, "true"));
        map.put(MAP_OPTIONS_ZOOM_CONTROL, zoomControlBool);
        boolean streetViewBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_STREET_VIEW, "true"));
        map.put(MAP_OPTIONS_STREET_VIEW, streetViewBool);
        boolean scaleControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_SCALE_CONTROL, "true"));
        map.put(MAP_OPTIONS_SCALE_CONTROL, scaleControlBool);
        boolean rotateControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_ROTATE_CONTROL, "false"));
        map.put(MAP_OPTIONS_ROTATE_CONTROL, rotateControlBool);
        boolean overviewControlBool = Boolean.parseBoolean(preferences.getValue(MAP_OPTIONS_OVERVIEW_CONTROL, "false"));
        map.put(MAP_OPTIONS_OVERVIEW_CONTROL, overviewControlBool);
        map.put(PREFERENCE_USE_PORTAL_JS_LIBS, preferences.getValue(PREFERENCE_USE_PORTAL_JS_LIBS, "true"));
        map.put(PREFERENCE_PORTAL_JS_NAMESPACE, preferences.getValue(PREFERENCE_PORTAL_JS_NAMESPACE, "up"));
        map.put("portalProtocol", this.portalProtocol);
        map.put("isMobile", "UniversalityMobile".equals(request.getProperty("themeName")));
        map.put("location", location);
        return new ModelAndView("mapView", map);
    }

    private MapData getMapData(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        String selectedMapDataUrl = preferences.getValue(PREFERENCE_MAP_DATA_URL, null);
        if (StringUtils.isBlank((String)selectedMapDataUrl)) {
            selectedMapDataUrl = this.mapDataUrl;
        }
        this.log.debug((Object)("Requesting map data from " + selectedMapDataUrl));
        return this.dao.getMap(selectedMapDataUrl);
    }

    private Double getLatOrLong(PortletPreferences preferences, BigDecimal mapValue, String preferenceName, String defaultValue) {
        String preferenceValue = preferences.getValue(preferenceName, null);
        if (preferenceValue != null) {
            return Double.parseDouble(preferenceValue);
        }
        if (mapValue != null) {
            return mapValue.doubleValue();
        }
        return Double.parseDouble(defaultValue);
    }

    @ResourceMapping
    public ModelAndView getMapData(ResourceRequest request, ResourceResponse response) {
        this.log.debug((Object)"Getting map data during resource request");
        MapData mapData = this.getMapData((PortletRequest)request);
        String etag = String.valueOf(mapData.hashCode());
        String requestEtag = request.getETag();
        if (request.getETag() != null && etag.equals(requestEtag)) {
            response.getCacheControl().setExpirationTime(360);
            response.getCacheControl().setUseCachedContent(true);
            response.setProperty("portlet.http-status-code", Integer.toString(304));
            return new ModelAndView("json", Collections.emptyMap());
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(360);
        ModelAndView mv = new ModelAndView("json");
        mv.addObject((Object)mapData);
        return mv;
    }
}

