/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.dao;

import com.google.map.kml.Document;
import com.google.map.kml.Kml;
import com.google.map.kml.Placemark;
import com.google.map.kml.Style;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.maps.dao.IMapDao;
import org.jasig.portlet.maps.model.xml.DefaultLocation;
import org.jasig.portlet.maps.model.xml.Location;
import org.jasig.portlet.maps.model.xml.MapData;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class GoogleMyMapsDaoImpl
implements IMapDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> categories;
    private Map<String, String> addresses;
    private Resource kmlFile;
    private double defaultLatitude;
    private double defaultLongitude;
    private Policy policy;

    @Required
    public void setCategories(Map<String, String> categories) {
        this.categories = categories;
    }

    public void setAddresses(Map<String, String> addresses) {
        this.addresses = addresses;
    }

    @Value(value="${map.googlemymapsdao.file:classpath:/mymap.kml}")
    public void setKmlFile(Resource kmlFile) {
        this.kmlFile = kmlFile;
    }

    @Value(value="${map.default.latitude:41.300937}")
    public void setDefaultLatitude(double defaultLatitude) {
        this.defaultLatitude = defaultLatitude;
    }

    @Value(value="${map.default.longitude:-72.932103}")
    public void setDefaultLongitude(double defaultLongitude) {
        this.defaultLongitude = defaultLongitude;
    }

    @Value(value="${map.policy.file:classpath:/antisamy-textonly.xml}")
    public void setPolicy(Resource policyFile) throws PolicyException, IOException {
        this.policy = Policy.getInstance((InputStream)policyFile.getInputStream());
    }

    @Cacheable(value={"mapCache"})
    public MapData getMap(String selectedMapDataUrl) {
        MapData map = new MapData();
        Kml kml = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Kml.class});
            Unmarshaller u = jc.createUnmarshaller();
            kml = (Kml)u.unmarshal(this.kmlFile.getInputStream());
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to parse KML file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"Failed to locate KML file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"IO Exception reading KML file", (Throwable)e);
        }
        Document doc = kml.getDocument();
        HashMap styles = new HashMap();
        for (Style style : doc.getStyle()) {
            String iconUrl;
            if (styles.containsKey(style.getId()) || !this.categories.containsKey(iconUrl = style.getIconStyle().getIcon().getHref())) continue;
            styles.put("#".concat(style.getId()), this.categories.get(iconUrl));
        }
        AntiSamy as = new AntiSamy();
        int index = 0;
        for (Placemark placemark : doc.getPlacemark()) {
            Location location = new Location();
            location.setName(placemark.getName());
            try {
                CleanResults cr = as.scan(placemark.getDescription(), this.policy);
                location.setDescription(cr.getCleanHTML());
            }
            catch (ScanException e) {
                this.log.warn((Object)"Exception scanning description", (Throwable)e);
            }
            catch (PolicyException e) {
                this.log.warn((Object)"Exception cleaning description", (Throwable)e);
            }
            if (this.addresses != null && this.addresses.containsKey(placemark.getName())) {
                location.setAddress((String)this.addresses.get(placemark.getName()));
            }
            String[] coordinates = placemark.getPoint().getCoordinates().split(",");
            location.setLatitude(new BigDecimal(Double.parseDouble(coordinates[1])));
            location.setLongitude(new BigDecimal(Double.parseDouble(coordinates[0])));
            location.setAbbreviation(String.valueOf(index));
            ++index;
            if (styles.containsKey(placemark.getStyleUrl())) {
                location.getCategories().add(styles.get(placemark.getStyleUrl()));
            }
            map.getLocations().add(location);
        }
        this.postProcessData(map);
        return map;
    }

    protected void postProcessData(MapData map) {
        DefaultLocation defaultLocation = new DefaultLocation();
        defaultLocation.setLatitude(new BigDecimal(this.defaultLatitude));
        defaultLocation.setLongitude(new BigDecimal(this.defaultLongitude));
        map.setDefaultLocation(defaultLocation);
        for (Location location : map.getLocations()) {
            StringBuffer searchString = new StringBuffer();
            searchString.append(location.getName().toLowerCase());
            searchString.append("~");
            searchString.append(location.getAbbreviation().toLowerCase());
            searchString.append("~");
            searchString.append(StringUtils.join((Collection)location.getSearchKeys(), (String)"~"));
            location.setSearchText(searchString.toString());
        }
    }
}

