/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.maps.dao;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.maps.dao.IMapDao;
import org.jasig.portlet.maps.model.xml.Location;
import org.jasig.portlet.maps.model.xml.MapData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestfulJsonMapDaoImpl
implements IMapDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private RestTemplate restTemplate;

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Cacheable(value={"mapCache"})
    public MapData getMap(String selectedMapDataUrl) {
        this.log.debug((Object)("Fetching json data file from URL " + selectedMapDataUrl));
        MapData map = (MapData)this.restTemplate.getForObject(selectedMapDataUrl, MapData.class, Collections.emptyMap());
        this.postProcessData(map);
        return map;
    }

    protected void postProcessData(MapData map) {
        for (Location location : map.getLocations()) {
            StringBuffer searchString = new StringBuffer();
            searchString.append(location.getName().toLowerCase());
            searchString.append("~");
            searchString.append(location.getAbbreviation().toLowerCase());
            searchString.append("~");
            searchString.append(StringUtils.join((Collection)location.getSearchKeys(), (String)"~"));
            location.setSearchText(searchString.toString());
        }
    }
}

