/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jasig.portlet.notice.JsonAttributesDeserializer;
import org.jasig.portlet.notice.JsonAttributesSerializer;
import org.jasig.portlet.notice.JsonDateDeserializer;
import org.jasig.portlet.notice.JsonDateSerializer;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationState;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationEntry
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String source;
    private String id;
    private String title;
    private String url;
    private String linkText;
    private int priority;
    private Date dueDate;
    private String image;
    private String body;
    private List<NotificationAttribute> attributes = Collections.emptyList();
    private List<NotificationAction> availableActions = Collections.emptyList();
    private Map<NotificationState, Date> states = Collections.emptyMap();

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @JsonSerialize(using=JsonDateSerializer.class)
    public Date getDueDate() {
        return this.dueDate;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String imageUrl) {
        this.image = imageUrl;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonSerialize(using=JsonAttributesSerializer.class)
    public List<NotificationAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @JsonDeserialize(using=JsonAttributesDeserializer.class)
    public void setAttributes(List<NotificationAttribute> attributes) {
        this.attributes = new ArrayList<NotificationAttribute>(attributes);
    }

    public List<NotificationAction> getAvailableActions() {
        return Collections.unmodifiableList(this.availableActions);
    }

    public void setAvailableActions(List<NotificationAction> availableActions) {
        this.availableActions = new ArrayList<NotificationAction>();
        for (NotificationAction action : availableActions) {
            action.setTarget(this);
            this.availableActions.add(action);
        }
    }

    public Map<NotificationState, Date> getStates() {
        return Collections.unmodifiableMap(this.states);
    }

    public void setStates(Map<NotificationState, Date> states) {
        this.states = new HashMap<NotificationState, Date>(states);
    }

    public Object clone() throws CloneNotSupportedException {
        NotificationEntry rslt = (NotificationEntry)super.clone();
        ArrayList<NotificationAttribute> atrList = new ArrayList<NotificationAttribute>(this.attributes.size());
        for (NotificationAttribute attr : this.attributes) {
            atrList.add((NotificationAttribute)attr.clone());
        }
        rslt.setAttributes(atrList);
        ArrayList<NotificationAction> actList = new ArrayList<NotificationAction>(this.availableActions.size());
        for (NotificationAction action : this.availableActions) {
            actList.add((NotificationAction)action.clone());
        }
        rslt.setAvailableActions(actList);
        return rslt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

