/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import java.util.Date;
import java.util.Set;

public enum NotificationState {
    ISSUED,
    UPDATED,
    PUSHED,
    TEXTED,
    EMAILED,
    READ,
    ACKNOWLEDGED,
    FAVORITED,
    SNOOZED{
        private static final long MILLIS_IN_ONE_HOUR = 3600000L;
        private int snoozePeriodHours = 72;

        public void setSnoozePeriodHours(int snoozePeriodHours) {
            this.snoozePeriodHours = snoozePeriodHours;
        }

        @Override
        public boolean isActive(Date timestamp, Set<NotificationState> subsequentHistory) {
            long timeout = timestamp.getTime() + (long)this.snoozePeriodHours * 3600000L;
            return System.currentTimeMillis() > timeout;
        }
    }
    ,
    IN_PROGRESS{

        @Override
        public boolean isActive(Date timestamp, Set<NotificationState> subsequentHistory) {
            NotificationState completed = NotificationState.valueOf("COMPLETED");
            return !subsequentHistory.contains((Object)completed);
        }
    }
    ,
    COMPLETED{

        @Override
        public boolean isActive(Date timestamp, Set<NotificationState> subsequentHistory) {
            return !subsequentHistory.contains((Object)IN_PROGRESS);
        }
    }
    ,
    ARCHIVED;


    public boolean isActive(Date timestamp, Set<NotificationState> subsequentHistory) {
        return true;
    }
}

