/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationResponse
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<NotificationCategory> categories;
    private List<NotificationError> errors;
    @JsonIgnore
    @XmlTransient
    private boolean cloned = false;

    public NotificationResponse() {
        this.categories = new ArrayList<NotificationCategory>();
        this.errors = new ArrayList<NotificationError>();
    }

    public NotificationResponse(NotificationResponse response) {
        this(response.getCategories(), response.getErrors());
    }

    public NotificationResponse(List<NotificationCategory> categories, List<NotificationError> errors) {
        this.categories = new ArrayList<NotificationCategory>(categories);
        this.errors = new ArrayList<NotificationError>(errors);
    }

    public List<NotificationCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void setCategories(List<NotificationCategory> categories) {
        this.categories = new ArrayList<NotificationCategory>(categories);
    }

    public List<NotificationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void setErrors(List<NotificationError> errors) {
        this.errors = new ArrayList<NotificationError>(errors);
    }

    public NotificationEntry findNotificationEntryById(String notificationId) {
        if (notificationId == null) {
            String msg = "Argument 'notificationId' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        NotificationEntry rslt = null;
        for (NotificationCategory category : this.categories) {
            for (NotificationEntry entry : category.getEntries()) {
                if (!notificationId.equals(entry.getId())) continue;
                rslt = entry;
                break;
            }
            if (rslt == null) continue;
            break;
        }
        return rslt;
    }

    public NotificationResponse combine(NotificationResponse response) {
        NotificationResponse rslt = new NotificationResponse(this);
        rslt.addCategories(response.getCategories());
        rslt.addErrors(response.getErrors());
        return rslt;
    }

    public NotificationResponse filterErrors(Set<Integer> hiddenErrorKeys) {
        NotificationResponse rslt = new NotificationResponse(this);
        ArrayList<NotificationError> filteredErrors = new ArrayList<NotificationError>();
        for (NotificationError r : this.errors) {
            if (hiddenErrorKeys.contains(r.getKey())) continue;
            filteredErrors.add(r);
        }
        rslt.setErrors(filteredErrors);
        return rslt;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NotificationResponse [categories=");
        builder.append(this.categories);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        NotificationResponse rslt = (NotificationResponse)super.clone();
        ArrayList<NotificationCategory> cList = new ArrayList<NotificationCategory>(this.categories.size());
        for (NotificationCategory category : this.categories) {
            cList.add((NotificationCategory)category.clone());
        }
        rslt.setCategories(cList);
        ArrayList<NotificationError> eList = new ArrayList<NotificationError>(this.errors.size());
        for (NotificationError error : this.errors) {
            eList.add((NotificationError)error.clone());
        }
        rslt.setErrors(eList);
        rslt.setCloned(true);
        return rslt;
    }

    private void addCategories(List<NotificationCategory> newCategories) {
        for (NotificationCategory newCategory : newCategories) {
            boolean found = false;
            for (NotificationCategory myCategory : this.categories) {
                if (!myCategory.getTitle().toLowerCase().equals(newCategory.getTitle().toLowerCase())) continue;
                found = true;
                myCategory.addEntries(newCategory.getEntries());
            }
            if (found) continue;
            this.categories.add(newCategory);
        }
    }

    private void addErrors(List<NotificationError> newErrors) {
        for (NotificationError error : newErrors) {
            this.errors.add(error);
        }
    }

    public NotificationResponse cloneIfNotCloned() {
        try {
            return this.isCloned() ? this : (NotificationResponse)this.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.error("Failed to clone() the sourceResponse", (Throwable)e);
            return this;
        }
    }

    public boolean isCloned() {
        return this.cloned;
    }

    private void setCloned(boolean cloned) {
        this.cloned = cloned;
    }
}

