/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationError
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String error;
    private String source;
    private int key = -1;

    public NotificationError() {
    }

    public NotificationError(String error, String source) {
        this.error = error;
        this.source = source;
        this.updateKey(source, error);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
        this.updateKey(source, this.error);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
        this.updateKey(this.source, error);
    }

    public int getKey() {
        return this.key;
    }

    private void updateKey(String source, String error) {
        this.key = new String(source + ":" + error).hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        NotificationError rslt = (NotificationError)super.clone();
        return rslt;
    }

    public NotificationError cloneNoExceptions() {
        try {
            return (NotificationError)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof NotificationError) {
            NotificationError temp = (NotificationError)object;
            return temp.getKey() == this.getKey();
        }
        return false;
    }

    public String toString() {
        return "org.jasig.portlet.notice.serverresponse.NotificationError\n\tSource            = " + this.source + "\n\tError             = " + this.error + "\n\tKey               = " + this.key + "\n";
    }
}

