/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NotificationResponse
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final NotificationResponse EMPTY_RESPONSE = new NotificationResponse(){

        @Override
        public void setCategories(List<NotificationCategory> categories) {
            throw new UnsupportedOperationException("NotificationResponse.EMPTY_RESPONSE is and must be immutable");
        }

        @Override
        public void setErrors(List<NotificationError> errors) {
            throw new UnsupportedOperationException("NotificationResponse.EMPTY_RESPONSE is and must be immutable");
        }
    };
    @XmlTransient
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<NotificationCategory> categories = new ArrayList<NotificationCategory>();
    private List<NotificationError> errors = new ArrayList<NotificationError>();
    @JsonIgnore
    @XmlTransient
    private boolean cloned = false;

    public NotificationResponse() {
    }

    public NotificationResponse(NotificationResponse response) {
        this(response.getCategories(), response.getErrors());
    }

    public NotificationResponse(List<NotificationCategory> categories, List<NotificationError> errors) {
        this.setCategories(categories);
        this.setErrors(errors);
    }

    public List<NotificationCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public void setCategories(List<NotificationCategory> categories) {
        this.categories.clear();
        if (categories != null) {
            this.categories.addAll(categories.stream().map(NotificationCategory::cloneNoExceptions).collect(Collectors.toList()));
        }
    }

    public List<NotificationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void setErrors(List<NotificationError> errors) {
        this.errors.clear();
        this.addErrors(errors);
    }

    public NotificationEntry findNotificationEntryById(String notificationId) {
        if (notificationId == null) {
            String msg = "Argument 'notificationId' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        NotificationEntry rslt = null;
        for (NotificationCategory category : this.categories) {
            for (NotificationEntry entry : category.getEntries()) {
                if (!notificationId.equals(entry.getId())) continue;
                rslt = entry;
                break;
            }
            if (rslt == null) continue;
            break;
        }
        return rslt;
    }

    public NotificationResponse combine(NotificationResponse response) {
        NotificationResponse rslt = new NotificationResponse(this);
        rslt.addCategories(response.getCategories());
        rslt.addErrors(response.getErrors());
        return rslt;
    }

    public NotificationResponse filterErrors(Set<Integer> hiddenErrorKeys) {
        NotificationResponse rslt = new NotificationResponse(this);
        ArrayList<NotificationError> filteredErrors = new ArrayList<NotificationError>();
        for (NotificationError r : this.errors) {
            if (hiddenErrorKeys.contains(r.getKey())) continue;
            filteredErrors.add(r);
        }
        rslt.setErrors(filteredErrors);
        return rslt;
    }

    public NotificationResponse filter(Predicate<NotificationEntry> predicate) {
        List<NotificationCategory> filteredCategories = this.categories.stream().map(category -> {
            List<NotificationEntry> filteredEntries = category.getEntries().stream().filter(predicate).collect(Collectors.toList());
            return filteredEntries.size() > 0 ? new NotificationCategory(category.getTitle(), filteredEntries) : null;
        }).filter((? super T value) -> value != null).collect(Collectors.toList());
        return new NotificationResponse(filteredCategories, this.getErrors());
    }

    @JsonIgnore
    @XmlTransient
    public int size() {
        return this.categories.stream().map(NotificationCategory::getEntries).mapToInt(List::size).sum();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NotificationResponse [categories=");
        builder.append(this.categories);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        NotificationResponse rslt = (NotificationResponse)super.clone();
        ArrayList<NotificationCategory> cList = new ArrayList<NotificationCategory>(this.categories.size());
        for (NotificationCategory category : this.categories) {
            cList.add((NotificationCategory)category.clone());
        }
        rslt.setCategories(cList);
        ArrayList<NotificationError> eList = new ArrayList<NotificationError>(this.errors.size());
        for (NotificationError error : this.errors) {
            eList.add((NotificationError)error.clone());
        }
        rslt.setErrors(eList);
        rslt.setCloned(true);
        return rslt;
    }

    private void addCategories(List<NotificationCategory> newCategories) {
        if (newCategories == null) {
            return;
        }
        newCategories = newCategories.parallelStream().map(NotificationCategory::cloneNoExceptions).collect(Collectors.toList());
        Map<String, NotificationCategory> catsByName = this.categories.parallelStream().collect(Collectors.toMap(c -> c.getTitle().toLowerCase(), c -> c));
        Map<Boolean, List<NotificationCategory>> matchingNewCats = newCategories.stream().collect(Collectors.partitioningBy(c -> catsByName.containsKey(c.getTitle().toLowerCase())));
        matchingNewCats.get(Boolean.TRUE).stream().forEachOrdered(c -> ((NotificationCategory)catsByName.get(c.getTitle().toLowerCase())).addEntries(c.getEntries()));
        this.categories.addAll((Collection<NotificationCategory>)matchingNewCats.get(Boolean.FALSE));
    }

    private void addErrors(List<NotificationError> newErrors) {
        if (newErrors != null) {
            this.errors.addAll(newErrors.stream().map(NotificationError::cloneNoExceptions).collect(Collectors.toList()));
        }
    }

    public NotificationResponse cloneIfNotCloned() {
        try {
            return this.isCloned() ? this : (NotificationResponse)this.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.error("Failed to clone() the sourceResponse", (Throwable)e);
            return this;
        }
    }

    private boolean isCloned() {
        return this.cloned;
    }

    private void setCloned(boolean cloned) {
        this.cloned = cloned;
    }
}

