/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller.notification;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class NotificationController {
    public static final String ATTRIBUTE_HIDDEN_ERRORS = NotificationController.class.getName() + ".ATTRIBUTE_HIDDEN_ERRORS";
    private Log log = LogFactory.getLog(this.getClass());
    @Resource(name="rootNotificationService")
    private INotificationService notificationService;

    @RenderMapping
    public String showNotificationsList() {
        this.log.trace((Object)"In showNotificationsList");
        return "notificationsList";
    }

    @ResourceMapping(value="GET-NOTIFICATIONS")
    public ModelAndView getNotifications(ResourceRequest req) throws IOException {
        this.log.trace((Object)"In getNotifications");
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            PortletSession session = req.getPortletSession(true);
            NotificationResponse notifications = this.notificationService.fetch(req);
            HashSet hidden = (HashSet)session.getAttribute(ATTRIBUTE_HIDDEN_ERRORS);
            if (hidden == null) {
                hidden = new HashSet();
                session.setAttribute(ATTRIBUTE_HIDDEN_ERRORS, hidden);
            }
            notifications = notifications.filterErrors((Set)hidden);
            model.put("notificationResponse", notifications);
            return new ModelAndView("json", model);
        }
        catch (Exception ex) {
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
            model.put("errorMessage", ex.getMessage());
            return new ModelAndView("json", model);
        }
    }

    @ActionMapping(params={"action=hideError"})
    public void hideError(ActionRequest req, ActionResponse res, @RequestParam(value="errorKey") String errorKey) throws IOException {
        PortletSession session = req.getPortletSession(true);
        HashSet<Integer> hidden = (HashSet<Integer>)session.getAttribute(ATTRIBUTE_HIDDEN_ERRORS);
        if (hidden == null) {
            hidden = new HashSet<Integer>();
            session.setAttribute(ATTRIBUTE_HIDDEN_ERRORS, hidden);
        }
        int errorKeyInt = 0;
        try {
            errorKeyInt = Integer.parseInt(errorKey);
        }
        catch (NumberFormatException nfe) {
            this.log.error((Object)("Value of errorKey must be an integer, was:  " + errorKey), (Throwable)nfe);
        }
        hidden.add(errorKeyInt);
    }
}

